package org.baderlab.pdzsvmstruct.data;

import org.baderlab.pdzsvmstruct.data.manager.DataFileManager;
import org.baderlab.pdzsvmstruct.utils.Constants;
import org.baderlab.pdzsvmstruct.utils.PDZSVMUtils;

import java.util.List;

/**
 * Copyright (c) 2011 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVMStruct.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVMStruct.  If not, see <http://www.gnu.org/licenses/>.
 */

public class DataRepository
{

    // Phage Display
    public List humanPosSidhuGenomicPDBList;

    // Protein Microarray
    public List mousePosPMOrphanPDBList;
    public List mouseNegPMOrphanPDBList;

    public List mousePosPMPDBList;
    public List mouseNegPMPDBList;

    public List wormPosPMPDBList;
    public List wormNegPMPDBList;

    public List flyPosPMPDBList;
    public List flyNegPMPDBList;;

    public String codonBiasFile = null;

    // Protein Microarray
    public String mousePosPMOrphanPDBFile = null;
    public String mouseNegPMOrphanPDBFile = null;

    public String mousePosPMPDBFile = null;
    public String mouseNegPMPDBFile = null;

    public String flyPosPMPDBFile = null;
    public String flyNegPMPDBFile = null;

    public String wormPosPMPDBFile = null;
    public String wormNegPMPDBFile = null;

    public String humanPosSidhuGenomicPDBFile = null;

    private static  DataRepository ref = null;

    public static DataRepository getInstance()
    {
        if (ref == null)
            ref = new DataRepository();

        return ref;
    }
    private DataRepository()
    {
        System.out.println("\tInitializing data repository...");
        DataFileManager df = new DataFileManager();

        codonBiasFile = DataFileManager.NNK_CODON_BIAS_FILENAME;
        humanPosSidhuGenomicPDBFile = df.getDataFile(Constants.SIDHU_HUMAN_G_PDB, Constants.PHAGE_DISPLAY, Constants.CLASS_YES);
        mousePosPMOrphanPDBFile = df.getDataFile(Constants.CHEN_MOUSE_ORPHAN_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        mouseNegPMOrphanPDBFile = df.getDataFile(Constants.CHEN_MOUSE_ORPHAN_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        mousePosPMPDBFile = df.getDataFile(Constants.CHEN_MOUSE_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        mouseNegPMPDBFile = df.getDataFile(Constants.CHEN_MOUSE_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        flyPosPMPDBFile = df.getDataFile(Constants.CHEN_FLY_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        flyNegPMPDBFile = df.getDataFile(Constants.CHEN_FLY_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        wormPosPMPDBFile = df.getDataFile(Constants.CHEN_WORM_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        wormNegPMPDBFile = df.getDataFile(Constants.CHEN_WORM_PDB, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        initProfileLists();
    }
    private void initProfileLists()
    {
        try
        {
            int numPositions = Constants.NUM_RES_POS;
            System.out.println("Num positions:  " +numPositions);
            flyPosPMPDBList = PDZSVMUtils.readProteinProfileList(flyPosPMPDBFile,codonBiasFile,numPositions, false);
            flyNegPMPDBList = PDZSVMUtils.readProteinProfileList(flyNegPMPDBFile,codonBiasFile,numPositions, false);
            wormPosPMPDBList = PDZSVMUtils.readProteinProfileList(wormPosPMPDBFile,codonBiasFile,numPositions, false);
            wormNegPMPDBList = PDZSVMUtils.readProteinProfileList(wormNegPMPDBFile,codonBiasFile,numPositions, false);
            mousePosPMOrphanPDBList = PDZSVMUtils.readProteinProfileList(mousePosPMOrphanPDBFile,codonBiasFile,numPositions, false);
            mouseNegPMOrphanPDBList = PDZSVMUtils.readProteinProfileList(mouseNegPMOrphanPDBFile,codonBiasFile,numPositions, false);
            mousePosPMPDBList = PDZSVMUtils.readProteinProfileList(mousePosPMPDBFile,codonBiasFile,numPositions, false);
            mouseNegPMPDBList = PDZSVMUtils.readProteinProfileList(mouseNegPMPDBFile,codonBiasFile,numPositions, false);
            humanPosSidhuGenomicPDBList = PDZSVMUtils.readProteinProfileList(humanPosSidhuGenomicPDBFile,codonBiasFile,numPositions);
            System.out.println("\tRemoving sequences that contain X...");
            humanPosSidhuGenomicPDBList = DataLoader.filterOutXInteractions(humanPosSidhuGenomicPDBList);
        }
        catch(Exception e)
        {
            System.out.println("Exception: " + e);
        }
    }

    public Object clone()
            throws CloneNotSupportedException
    {
        throw new CloneNotSupportedException();
    }
}
