/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.baderlab.brain.BindingPeptideList;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinTerminus;
import org.biojava.bio.BioException;

public class PeptideToProfileReader {
    public static List readPeptidesAsProfiles(File projectFile, double fuzzFactor) {
        return PeptideToProfileReader.readPeptidesAsProfiles(projectFile, -1, null, fuzzFactor, null, true, false);
    }

    public static List readPeptidesAsProfiles(File projectFile, double fuzzFactor, File codonBiasFile, boolean uniquePeptides, boolean useSequenceLogoDistribution) {
        return PeptideToProfileReader.readPeptidesAsProfiles(projectFile, -1, null, fuzzFactor, codonBiasFile, uniquePeptides, useSequenceLogoDistribution);
    }

    public static List readPeptidesAsProfiles(File projectFile, int profileLength, ProteinTerminus terminus, double fuzzFactor, File codonBiasFile, boolean uniquePeptides, boolean useSequenceLogoDistribution) {
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        ArrayList<ProteinProfile> profileList = new ArrayList<ProteinProfile>();
        if (projectFile == null) {
            throw new RuntimeException("Project file must be specified.");
        }
        Iterator files = null;
        try {
            if (profileProjectFile.isProjectFile(projectFile.toString())) {
                profileProjectFile.read(projectFile.toString());
                files = profileProjectFile.getFileNames();
            } else {
                ArrayList<String> fileList = new ArrayList<String>(1);
                fileList.add(projectFile.toString());
                files = fileList.iterator();
            }
            while (files.hasNext()) {
                String peptideListFileName = (String)files.next();
                BindingPeptideList peptideList = new BindingPeptideList();
                peptideList.read(peptideListFileName);
                DatabaseReference proteinReference = peptideList.getProteinXref();
                String profileName = new String(peptideList.getProteinName() + "-" + Integer.toString(peptideList.getDomainNumber()));
                ProteinProfile profile = profileLength > 0 ? new ProteinProfile(peptideList.getSequenceIteratorByLength(profileLength, terminus, false, uniquePeptides), fuzzFactor, profileName, useSequenceLogoDistribution) : new ProteinProfile(peptideList.getSequenceIterator(false, uniquePeptides), fuzzFactor, profileName, useSequenceLogoDistribution);
                if (codonBiasFile != null) {
                    profile.reWeightByCodonBias(codonBiasFile);
                }
                profile.setProteinXrefList(peptideList.getProteinXrefList());
                profile.setProteinReference(proteinReference);
                profile.setDomainReference(peptideList.getDomainXref());
                profile.setDomainNumber(peptideList.getDomainNumber());
                profile.setDomainSequence(peptideList.getDomainSequence());
                profile.setExperimentalMethod(peptideList.getExperimentalMethod());
                profile.setDomainSequenceStart(peptideList.getDomainRangeStart());
                profile.setDomainSequenceStop(peptideList.getDomainRangeStop());
                profile.setComment(peptideList.getComment());
                profile.setProteinName(peptideList.getProteinName());
                profile.setOrganism(peptideList.getOrganism());
                profileList.add(profile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return profileList;
    }
}

