/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ConcurrentModificationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.util.ColorUtil;
import org.ujmp.gui.util.GraphicsUtil;
import org.ujmp.gui.util.UIDefaults;

public class MatrixRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 942689931503793487L;
    private static final Logger logger = Logger.getLogger(MatrixRenderer.class.getName());
    private MatrixGUIObject matrix = null;
    private int width = 0;
    private int height = 0;
    private static int PADDINGX = UIManager.getInt("Table.paddingX");
    private static int PADDINGY = UIManager.getInt("Table.paddingY");

    public MatrixRenderer() {
    }

    public MatrixRenderer(MatrixGUIObject m) {
        this.setMatrix(m);
    }

    public void setMatrix(MatrixGUIObject m) {
        this.matrix = m;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.matrix = value instanceof MatrixGUIObject ? (MatrixGUIObject)value : (value instanceof Matrix ? (MatrixGUIObject)((Matrix)value).getGUIObject() : null);
        this.width = table.getColumnModel().getColumn(column).getWidth() - 1;
        this.height = table.getRowHeight(row) - 1;
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        block14: {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.width, this.height);
            try {
                if (this.matrix != null) {
                    this.matrix = (MatrixGUIObject)MathUtil.getMatrix(this.matrix.getMatrix()).getGUIObject();
                    int width = this.getWidth();
                    int height = this.getHeight();
                    width = width == 0 ? 1 : width;
                    height = height == 0 ? 1 : height;
                    int totalColumn = this.matrix.getColumnCount();
                    int totalRows = this.matrix.getRowCount();
                    int xsize = Math.min(totalColumn, width);
                    int ysize = Math.min(totalRows, height);
                    xsize = xsize == 0 ? 1 : xsize;
                    ysize = ysize == 0 ? 1 : ysize;
                    double stepsizeX = (double)totalColumn / (double)width;
                    double stepsizeY = (double)totalRows / (double)height;
                    if (stepsizeX < 1.0) {
                        stepsizeX = 1.0;
                    }
                    if (stepsizeY < 1.0) {
                        stepsizeY = 1.0;
                    }
                    BufferedImage bufferedImage = new BufferedImage(xsize, ysize, 1);
                    int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    if (stepsizeX != 1.0 || stepsizeY != 1.0) {
                        int pos = 0;
                        int y = 0;
                        while (y < ysize) {
                            int x = 0;
                            while (x < xsize) {
                                int mx = (int)Math.floor((double)x * stepsizeX);
                                int my = (int)Math.floor((double)y * stepsizeY);
                                Color col = ColorUtil.fromObject(this.matrix.getValueAt(my, mx));
                                pixels[pos++] = (col.getRed() << 16) + (col.getGreen() << 8) + col.getBlue();
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        Iterable<long[]> cos = this.matrix.coordinates();
                        if (cos != null) {
                            for (long[] c : cos) {
                                if (c == null) continue;
                                Color col = ColorUtil.fromObject(this.matrix.getValueAt(c));
                                int pos = MatrixRenderer.getPosition(totalColumn, c[0], c[1]);
                                pixels[pos] = (col.getRed() << 16) + (col.getGreen() << 8) + col.getBlue();
                            }
                        }
                    }
                    g2d.drawImage(bufferedImage, PADDINGX, PADDINGY, width - PADDINGX - PADDINGX, height - PADDINGY - PADDINGY, null);
                    if (width > 20 && this.matrix.isScalar()) {
                        Color col = ColorUtil.fromObject(this.matrix.getValueAt(0, 0));
                        g2d.setColor(ColorUtil.contrastBW(col));
                        String s = UJMPFormat.getSingleLineInstance().format(this.matrix.getValueAt(0, 0));
                        if (s != null && s.length() > 25) {
                            s = String.valueOf(s.substring(0, 25)) + "...";
                        }
                        GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
                    }
                    break block14;
                }
                g2d.setColor(Color.GRAY);
                g2d.drawLine(PADDINGX, PADDINGY, this.width - PADDINGX, this.height - PADDINGY);
                g2d.drawLine(PADDINGX, this.height - PADDINGY, this.width - PADDINGX, 0 + PADDINGY);
            }
            catch (ConcurrentModificationException width) {
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not paint", e);
            }
        }
    }

    private static int getPosition(long totalColumn, long currentRow, long currentColumn) {
        return (int)(totalColumn * currentRow + currentColumn);
    }

    public static void paintMatrix(Graphics g, Matrix matrix, int width, int height) {
        if (g == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(UIDefaults.AALIAS);
        if (matrix == null) {
            g2d.setColor(Color.GRAY);
            g2d.drawLine(PADDINGX, PADDINGY, width - PADDINGX, height - PADDINGY);
            g2d.drawLine(width - PADDINGX, PADDINGY, PADDINGX, height - PADDINGY);
        } else {
            g2d.translate(PADDINGX, PADDINGX);
            if (matrix.getColumnCount() > matrix.getRowCount()) {
                MatrixRenderer.paintMatrixOriginal(g2d, matrix, width - PADDINGX - PADDINGX, height - PADDINGY - PADDINGY);
            } else {
                MatrixRenderer.paintMatrixTransposed(g2d, matrix, width - PADDINGX - PADDINGX, height - PADDINGY - PADDINGY);
            }
            g2d.translate(-PADDINGX, -PADDINGX);
        }
    }

    private static void paintMatrixOriginal(Graphics g, Matrix matrix, int width, int height) {
        try {
            int cols = (int)matrix.getColumnCount();
            int rows = (int)matrix.getRowCount();
            width = width < 1 ? 1 : width;
            height = height < 1 ? 1 : height;
            int xSize = cols > 0 ? cols : 1;
            int ySize = rows > 0 ? rows : 1;
            xSize = xSize > 0 ? xSize : 1;
            ySize = ySize > 0 ? ySize : 1;
            int xStepSize = (int)Math.ceil((double)xSize / (double)width);
            int yStepSize = (int)Math.ceil((double)ySize / (double)height);
            int imgX = xSize / xStepSize;
            int imgY = ySize / yStepSize;
            imgX = imgX > 0 ? imgX : 1;
            imgY = imgY > 0 ? imgX : 1;
            BufferedImage bufferedImage = new BufferedImage(imgX, imgY, 1);
            Graphics2D g2d = (Graphics2D)g;
            Graphics2D bg = (Graphics2D)bufferedImage.getGraphics();
            bg.addRenderingHints(UIDefaults.AALIAS);
            int col = 0;
            while (col < cols) {
                int row = 0;
                while (row < rows) {
                    bg.setColor(ColorUtil.fromDouble(matrix.getAsDouble(row, col)));
                    bg.fillRect(col / xStepSize, row / yStepSize, 1, 1);
                    row += yStepSize;
                }
                col += xStepSize;
            }
            g2d.drawImage(bufferedImage, 0, 0, width, height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            if (width > 20 && matrix.isScalar()) {
                String s = UJMPFormat.getSingleLineInstance().format(matrix.getAsObject(0L, 0L));
                if (s != null && s.length() > 25) {
                    s = String.valueOf(s.substring(0, 25)) + "...";
                }
                g2d.setColor(ColorUtil.contrastBW(bg.getColor()));
                GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error painting matrix", e);
        }
    }

    private static void paintMatrixSquared(Graphics g, Matrix matrix, int width, int height) {
        try {
            long valueCount = matrix.getValueCount();
            width = width < 1 ? 1 : width;
            height = height < 1 ? 1 : height;
            int xSize = (int)Math.floor(Math.sqrt(valueCount));
            int ySize = (int)Math.ceil((double)valueCount / (double)xSize);
            xSize = xSize > 0 ? xSize : 1;
            ySize = ySize > 0 ? ySize : 1;
            int xStepSize = (int)Math.ceil((double)xSize / (double)width);
            int yStepSize = (int)Math.ceil((double)ySize / (double)height);
            int imgX = xSize / xStepSize;
            int imgY = ySize / yStepSize;
            imgX = imgX > 0 ? imgX : 1;
            imgY = imgY > 0 ? imgX : 1;
            BufferedImage bufferedImage = new BufferedImage(imgX, imgY, 1);
            Graphics2D g2d = (Graphics2D)g;
            Graphics2D bg = (Graphics2D)bufferedImage.getGraphics();
            bg.addRenderingHints(UIDefaults.AALIAS);
            int x = 0;
            int y = 0;
            int i = 0;
            while ((long)i < valueCount) {
                bg.setColor(ColorUtil.fromDouble(matrix.getAsDouble((long)i % matrix.getRowCount(), (long)i / matrix.getRowCount())));
                bg.fillRect(x / xStepSize, y / yStepSize, 1, 1);
                if (++x >= xSize) {
                    x = 0;
                    ++y;
                }
                ++i;
            }
            g2d.drawImage(bufferedImage, 0, 0, width, height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            if (width > 20 && matrix.isScalar()) {
                g2d.setColor(ColorUtil.contrastBW(bg.getColor()));
                GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, UJMPFormat.getSingleLineInstance().format(matrix.getAsObject(0L, 0L)));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error painting matrix", e);
        }
    }

    private static void paintMatrixTransposed(Graphics g, Matrix matrix, int width, int height) {
        try {
            int cols = (int)matrix.getColumnCount();
            int rows = (int)matrix.getRowCount();
            width = width < 1 ? 1 : width;
            height = height < 1 ? 1 : height;
            int ySize = cols > 0 ? cols : 1;
            int xSize = rows > 0 ? rows : 1;
            xSize = xSize > 0 ? xSize : 1;
            ySize = ySize > 0 ? ySize : 1;
            int xStepSize = (int)Math.ceil((double)xSize / (double)width);
            int yStepSize = (int)Math.ceil((double)ySize / (double)height);
            int imgX = xSize / xStepSize;
            int imgY = ySize / yStepSize;
            imgX = imgX > 0 ? imgX : 1;
            imgY = imgY > 0 ? imgX : 1;
            BufferedImage bufferedImage = new BufferedImage(imgX, imgY, 1);
            Graphics2D g2d = (Graphics2D)g;
            Graphics2D bg = (Graphics2D)bufferedImage.getGraphics();
            bg.addRenderingHints(UIDefaults.AALIAS);
            int col = 0;
            while (col < cols) {
                int row = 0;
                while (row < rows) {
                    bg.setColor(ColorUtil.fromDouble(matrix.getAsDouble(row, col)));
                    bg.fillRect(row / yStepSize, col / xStepSize, 1, 1);
                    row += yStepSize;
                }
                col += xStepSize;
            }
            g2d.drawImage(bufferedImage, 0, 0, width, height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            if (width > 20 && matrix.isScalar()) {
                g2d.setColor(ColorUtil.contrastBW(bg.getColor()));
                String s = UJMPFormat.getSingleLineInstance().format(matrix.getAsObject(0L, 0L));
                if (s != null && s.length() > 25) {
                    s = String.valueOf(s.substring(0, 25)) + "...";
                }
                GraphicsUtil.drawString(g2d, (double)width / 2.0, (double)height / 2.0 - 1.0, 0, 0, s);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error painting matrix", e);
        }
    }
}

