/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.ObjectAction;
import org.ujmp.gui.util.GUIUtil;

public abstract class AbstractMatrixAction
extends ObjectAction {
    private static final long serialVersionUID = 7005218564058853146L;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    private GUIObject variable = null;

    public AbstractMatrixAction(JComponent c, MatrixGUIObject matrix, GUIObject v) {
        super(c, matrix);
        this.variable = v;
    }

    public Calculation.Ret getRet() {
        return (Calculation.Ret)((Object)GUIUtil.getObject("Select return method", new Object[]{Calculation.Ret.ORIG, Calculation.Ret.NEW, Calculation.Ret.LINK}));
    }

    public Calculation.Ret getOrigOrNew() {
        return (Calculation.Ret)((Object)GUIUtil.getObject("Select return method", new Object[]{Calculation.Ret.ORIG, Calculation.Ret.NEW}));
    }

    public Calculation.Ret getNewOrLink() {
        return (Calculation.Ret)((Object)GUIUtil.getObject("Select return method", new Object[]{Calculation.Ret.NEW, Calculation.Ret.LINK}));
    }

    public long[] getSize() {
        return GUIUtil.getSize("Enter the size of the matrix (e.g. '5,4' -> 5 rows, 4 columns)");
    }

    public int getDimension() {
        int dimension = -1;
        if (dimension == -1) {
            if (this.getMatrixObject().getColumnCount() == 1) {
                dimension = 0;
            } else if (this.getMatrixObject().getRowCount() == 1) {
                dimension = 1;
            }
        }
        if (dimension == -1) {
            int i = JOptionPane.showOptionDialog(this.getComponent(), "Dimension", "Select Dimension", 0, 3, null, new String[]{"Row", "Column", "All"}, "Row");
            dimension = i == 2 ? Integer.MAX_VALUE : i;
        }
        return dimension;
    }

    public boolean getIgnoreMissing() {
        if (!this.getMatrixObject().getMatrix().containsMissingValues()) {
            return true;
        }
        return GUIUtil.getBoolean("Ignore missing values");
    }

    public Matrix getMatrix() {
        return this.getMatrixObject().getMatrix();
    }

    public MatrixGUIObject getMatrixObject() {
        MatrixGUIObject m = (MatrixGUIObject)this.getGUIObject();
        if (m != null) {
            int startRow = m.getRowSelectionModel().getMinSelectionIndex();
            int endRow = m.getRowSelectionModel().getMaxSelectionIndex();
            int startColumn = m.getColumnSelectionModel().getMinSelectionIndex();
            int endColumn = m.getColumnSelectionModel().getMaxSelectionIndex();
            if (startRow != -1 && startColumn != -1 && (startRow != endRow || startColumn != endColumn)) {
                m = (MatrixGUIObject)m.getMatrix().subMatrix(Calculation.Ret.LINK, startRow, startColumn, endRow, endColumn).getGUIObject();
            }
            return m;
        }
        return null;
    }

    public void setMatrix(MatrixGUIObject m) {
        this.setGUIObject(m);
    }

    public GUIObject getVariable() {
        return this.variable;
    }
}

