/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.treematrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.treematrix.TreeMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeMatrix
extends AbstractSparseDoubleMatrix2D
implements TreeMatrix {
    private static final long serialVersionUID = 7731771819651651188L;

    @Override
    public boolean contains(long ... coordinates) {
        return false;
    }

    @Override
    public final boolean isChild(Object parent, Object child) {
        return this.getChildren(parent).contains(child);
    }

    @Override
    public final boolean isChild(int parentId, int childId) {
        Object parent = this.getObject(parentId);
        Object child = this.getObject(childId);
        return this.isChild(parent, child);
    }

    @Override
    public final Object getObject(int index) {
        if (this.getObjectList() instanceof List) {
            return ((List)this.getObjectList()).get(index);
        }
        return new ArrayList<Object>(this.getObjectList()).get(index);
    }

    @Override
    public Object getParent(Object o) {
        return this.getParentMap().get(o);
    }

    @Override
    public void addChildren(Object parent, Collection<? extends Object> children) {
        for (Object object : children) {
            this.addChild(parent, object);
        }
    }

    @Override
    public final long[] getSize() {
        return new long[]{this.getObjectList().size(), this.getObjectList().size()};
    }

    @Override
    public final double getDouble(int row, int column) {
        return this.isChild(row, column) ? 1.0 : 0.0;
    }

    @Override
    public final double getDouble(long row, long column) {
        return this.getDouble((int)row, (int)column);
    }

    @Override
    public final void addChild(Object parent, Object child) {
        if (!this.getObjectList().contains(child)) {
            this.getObjectList().add(child);
        }
        this.getChildren(parent).add(child);
        this.getParentMap().put(child, parent);
        this.notifyGUIObject();
    }

    @Override
    public final void removeChild(Object parent, Object child) {
        this.getChildren(parent).remove(child);
        Object oldParent = this.getParentMap().get(child);
        if (parent.equals(oldParent)) {
            this.getParentMap().remove(child);
        }
        this.notifyGUIObject();
    }

    @Override
    public final void setDouble(double value, long row, long column) {
        this.setDouble(value, (int)row, (int)column);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        Object parent = this.getObject(row);
        Object child = this.getObject(column);
        if (value == 0.0) {
            this.removeChild(parent, child);
        } else {
            this.addChild(parent, child);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public final Object getChild(Object parent, int index) {
        return this.getChildren(parent).get(index);
    }

    @Override
    public final int getChildCount(Object parent) {
        return this.getChildren(parent).size();
    }

    @Override
    public final int getIndexOfChild(Object parent, Object child) {
        return this.getChildren(parent).indexOf(child);
    }

    @Override
    public final boolean isLeaf(Object node) {
        return this.getChildren(node).size() == 0;
    }

    @Override
    public final void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public final void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public final int getNumberOfObjects() {
        return this.getObjectList().size();
    }

    @Override
    public void addObject(Object o) {
        this.getObjectList().add(o);
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.TREE;
    }
}

