/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import java.util.regex.Pattern;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;

public class ReplaceRegex
extends AbstractStringCalculation {
    private static final long serialVersionUID = 8158807887609103123L;
    private Pattern searchPattern = null;
    private String replaceString = null;

    public ReplaceRegex(Matrix matrix, String searchString, String replaceString) {
        this(matrix, Pattern.compile(searchString), replaceString);
    }

    public ReplaceRegex(Matrix matrix, Pattern searchPattern, String replaceString) {
        super(matrix);
        this.searchPattern = searchPattern;
        this.replaceString = replaceString;
    }

    public String getString(long ... coordinates) throws MatrixException {
        String src = this.getSource().getAsString(coordinates);
        return src == null ? null : this.searchPattern.matcher(src).replaceAll(this.replaceString);
    }

    public static Matrix calc(Matrix source, Pattern search, String replacement) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(ValueType.STRING, source.getSize());
        for (long[] c : source.availableCoordinates()) {
            String src = source.getAsString(c);
            ret.setAsString(src == null ? null : search.matcher(src).replaceAll(replacement), c);
        }
        return ret;
    }

    public static Matrix calc(Matrix source, String searchString, String replacement) throws MatrixException {
        return ReplaceRegex.calc(source, Pattern.compile(searchString), replacement);
    }
}

