/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.ArrayList;
import java.util.Collections;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.longmatrix.LongMatrix2D;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.Sortable;

public class Sortrows
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -6935375114060680121L;
    private LongMatrix2D index = null;
    private long column = 0L;
    private boolean reverse = false;

    public Sortrows(Matrix m, long column, boolean reverse) {
        super(m);
        this.column = Math.abs(column);
        this.reverse = reverse;
        this.createSortIndex();
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        return this.getSource().getAsObject(this.index.getLong(coordinates[0], 0L), coordinates[1]);
    }

    private void createSortIndex() {
        Matrix m = this.getSource();
        long rowCount = m.getRowCount();
        ArrayList<Sortable<Object, Long>> rows = new ArrayList<Sortable<Object, Long>>();
        switch (m.getValueType()) {
            case BIGDECIMAL: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsBigDecimal(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case BIGINTEGER: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsBigInteger(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case DATE: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsDate(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case DOUBLE: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsDouble(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case INT: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsInt(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case FLOAT: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = Float.valueOf(m.getAsFloat(r, this.column));
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case CHAR: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = Character.valueOf(m.getAsChar(r, this.column));
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case BYTE: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsByte(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case BOOLEAN: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsBoolean(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case LONG: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsLong(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            case SHORT: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsShort(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break;
            }
            default: {
                Sortable<Object, Long> s;
                Object c;
                long r = 0L;
                while (r < rowCount) {
                    c = m.getAsString(r, this.column);
                    s = new Sortable<Object, Long>(c, r, true);
                    rows.add(s);
                    ++r;
                }
                break block0;
            }
        }
        Collections.sort(rows);
        if (this.reverse) {
            Collections.reverse(rows);
        }
        LongMatrix2D indexMatrix = (LongMatrix2D)MatrixFactory.zeros(ValueType.LONG, rows.size(), 1L);
        Annotation annotation = m.getAnnotation();
        if (annotation != null) {
            annotation = m.getAnnotation().clone();
            this.setAnnotation(annotation);
        }
        int r = 0;
        while (r < rows.size()) {
            indexMatrix.setLong((long)((Long)((Sortable)rows.get(r)).getObject()), r, 0);
            if (annotation != null) {
                long[] lArray = new long[2];
                lArray[0] = (Long)((Sortable)rows.get(r)).getObject();
                Object o = m.getAxisAnnotation(1, lArray);
                long[] lArray2 = new long[2];
                lArray2[0] = r;
                annotation.setAxisAnnotation(1, o, lArray2);
            }
            ++r;
        }
        this.index = indexMatrix;
    }

    public LongMatrix2D getIndex() {
        return this.index;
    }
}

