/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class ExportMatrixR {
    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixR.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixR.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer writer, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        String EOL = System.getProperty("line.separator");
        long nrow = matrix.getRowCount();
        long ncol = matrix.getColumnCount();
        writer.append("matrix(c(");
        int c = 0;
        while ((long)c < ncol) {
            writer.append("c(");
            int r = 0;
            while ((long)r < nrow) {
                writer.append(String.valueOf(matrix.getAsDouble(r, c)));
                if ((long)(r + 1) < nrow) {
                    writer.append(",");
                }
                ++r;
            }
            writer.append(")");
            if ((long)(c + 1) < ncol) {
                writer.append(",");
            }
            ++c;
        }
        writer.append("),ncol=" + ncol + ",nrow=" + nrow + ")" + EOL);
    }
}

