/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QR<T> {
    public static final int THRESHOLD = 100;
    public static final QR<Matrix> MATRIX = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final QR<Matrix> MATRIXLARGESINGLETHREADED = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            QR qr = null;
            if (UJMPSettings.isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            QR qr = null;
            if (UJMPSettings.isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.solve(source, b);
        }
    };
    public static final QR<Matrix> MATRIXLARGEMULTITHREADED = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            QR qr = null;
            if (UJMPSettings.isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            QR qr = null;
            if (UJMPSettings.isUseOjalgo()) {
                qr = DecompositionOps.QR_OJALGO;
            }
            if (qr == null && UJMPSettings.isUseEJML()) {
                qr = DecompositionOps.QR_EJML;
            }
            if (qr == null && UJMPSettings.isUseMTJ()) {
                qr = DecompositionOps.QR_MTJ;
            }
            if (qr == null) {
                qr = UJMP;
            }
            return qr.solve(source, b);
        }
    };
    public static final QR<Matrix> INSTANCE = MATRIX;
    public static final QR<Matrix> UJMP = new QR<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (source.getRowCount() >= source.getColumnCount()) {
                QRMatrix qr = new QRMatrix(source);
                return new Matrix[]{qr.getQ(), qr.getR()};
            }
            throw new MatrixException("only matrices m>=n are allowed");
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (source.getRowCount() >= source.getColumnCount()) {
                QRMatrix qr = new QRMatrix(source);
                return qr.solve(b);
            }
            throw new MatrixException("only matrices m>=n are allowed");
        }
    };
    public static final QR<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final QR<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;

    public T[] calc(T var1);

    public T solve(T var1, T var2);

    public static class QRMatrix {
        private static final long serialVersionUID = 2137461328307048867L;
        private final double[][] QR;
        private final int m;
        private final int n;
        private final double[] Rdiag;

        public QRMatrix(Matrix A) {
            this.QR = A.toDoubleArray();
            this.m = (int)A.getRowCount();
            this.n = (int)A.getColumnCount();
            this.Rdiag = new double[this.n];
            int k = 0;
            while (k < this.n) {
                double nrm = 0.0;
                int i = k;
                while (i < this.m) {
                    nrm = MathUtil.hypot(nrm, this.QR[i][k]);
                    ++i;
                }
                if (nrm != 0.0) {
                    if (this.QR[k][k] < 0.0) {
                        nrm = -nrm;
                    }
                    i = k;
                    while (i < this.m) {
                        double[] dArray = this.QR[i];
                        int n = k;
                        dArray[n] = dArray[n] / nrm;
                        ++i;
                    }
                    double[] dArray = this.QR[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                    int j = k + 1;
                    while (j < this.n) {
                        double s = 0.0;
                        int i2 = k;
                        while (i2 < this.m) {
                            s += this.QR[i2][k] * this.QR[i2][j];
                            ++i2;
                        }
                        s = -s / this.QR[k][k];
                        i2 = k;
                        while (i2 < this.m) {
                            double[] dArray2 = this.QR[i2];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                            ++i2;
                        }
                        ++j;
                    }
                }
                this.Rdiag[k] = -nrm;
                ++k;
            }
        }

        public final boolean isFullRank() {
            int j = 0;
            while (j < this.n) {
                if (this.Rdiag[j] == 0.0) {
                    return false;
                }
                ++j;
            }
            return true;
        }

        public final Matrix getH() {
            double[][] H = new double[this.m][this.n];
            int i = 0;
            while (i < this.m) {
                int j = 0;
                while (j < this.n) {
                    if (i >= j) {
                        H[i][j] = this.QR[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            return MatrixFactory.linkToArray(H);
        }

        public final Matrix getR() {
            double[][] R2 = new double[this.n][this.n];
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    R2[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
                    ++j;
                }
                ++i;
            }
            return MatrixFactory.linkToArray(R2);
        }

        public final Matrix getQ() {
            double[][] Q = new double[this.m][this.n];
            int k = this.n - 1;
            while (k >= 0) {
                int i = 0;
                while (i < this.m) {
                    Q[i][k] = 0.0;
                    ++i;
                }
                Q[k][k] = 1.0;
                int j = k;
                while (j < this.n) {
                    if (this.QR[k][k] != 0.0) {
                        double s = 0.0;
                        int i2 = k;
                        while (i2 < this.m) {
                            s += this.QR[i2][k] * Q[i2][j];
                            ++i2;
                        }
                        s = -s / this.QR[k][k];
                        i2 = k;
                        while (i2 < this.m) {
                            double[] dArray = Q[i2];
                            int n = j;
                            dArray[n] = dArray[n] + s * this.QR[i2][k];
                            ++i2;
                        }
                    }
                    ++j;
                }
                --k;
            }
            return MatrixFactory.linkToArray(Q);
        }

        public final Matrix solve(Matrix B) {
            int j;
            if (B.getRowCount() != (long)this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isFullRank()) {
                throw new RuntimeException("Matrix is rank deficient.");
            }
            int nx = (int)B.getColumnCount();
            double[][] X = B.toDoubleArray();
            int k = 0;
            while (k < this.n) {
                j = 0;
                while (j < nx) {
                    double s = 0.0;
                    int i = k;
                    while (i < this.m) {
                        s += this.QR[i][k] * X[i][j];
                        ++i;
                    }
                    s = -s / this.QR[k][k];
                    i = k;
                    while (i < this.m) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] + s * this.QR[i][k];
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            k = this.n - 1;
            while (k >= 0) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.Rdiag[k];
                }
                int i = 0;
                while (i < k) {
                    int j2 = 0;
                    while (j2 < nx) {
                        double[] dArray = X[i];
                        int n = j2;
                        dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                        ++j2;
                    }
                    ++i;
                }
                --k;
            }
            return MatrixFactory.linkToArray(X).subMatrix(Calculation.Ret.NEW, 0L, 0L, this.n - 1, nx - 1);
        }
    }
}

