/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Log10
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -5673588058854751554L;

    public Log10(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        double v = this.getSource().getAsDouble(coordinates);
        return Math.log(v) / Math.log(10.0);
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            double v = source.getAsDouble(c);
            ret.setAsDouble(Math.log(v) / Math.log(10.0), c);
        }
        return ret;
    }
}

