/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSetSet
implements Set<Integer>,
SortedSet<Integer> {
    BitSet bitset = new BitSet();

    public BitSetSet() {
    }

    public BitSetSet(BitSetSet source) {
        this.bitset.or(source.bitset);
    }

    @Override
    public boolean add(Integer e) {
        this.bitset.set(e);
        return true;
    }

    public void set(int start, int end) {
        this.bitset.set(start, end);
    }

    public void clear(int index) {
        this.bitset.clear(index);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c instanceof BitSetSet) {
            this.addAll((BitSetSet)c);
        } else {
            for (Integer n : c) {
                this.bitset.set(n);
            }
        }
        return true;
    }

    public void addAll(BitSetSet bss) {
        this.bitset.or(bss.bitset);
    }

    public BitSetSet clone() {
        return new BitSetSet(this);
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.bitset.get((Integer)o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.bitset.get((Integer)o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.bitset.isEmpty();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BitIterator();
    }

    @Override
    public boolean remove(Object o) {
        this.bitset.clear((Integer)o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            int i = (Integer)o;
            if (i < 0) continue;
            this.bitset.clear(i);
        }
        return true;
    }

    public String toString() {
        return this.bitset.toString();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        new Exception("not implemented").printStackTrace();
        return false;
    }

    @Override
    public int size() {
        return this.bitset.cardinality();
    }

    @Override
    public Object[] toArray() {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
        return comparator;
    }

    @Override
    public Integer first() {
        return this.bitset.nextSetBit(0);
    }

    @Override
    public SortedSet<Integer> headSet(Integer toElement) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public Integer last() {
        return this.bitset.length() - 1;
    }

    @Override
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    @Override
    public SortedSet<Integer> tailSet(Integer fromElement) {
        new Exception("not implemented").printStackTrace();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BitIterator
    implements Iterator<Integer> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index != -1 && BitSetSet.this.bitset.nextSetBit(this.index) != -1;
        }

        @Override
        public Integer next() {
            int ret = BitSetSet.this.bitset.nextSetBit(this.index);
            this.index = BitSetSet.this.bitset.nextSetBit(ret + 1);
            return ret;
        }

        @Override
        public void remove() {
            new Exception("not implemented").printStackTrace();
        }
    }
}

