/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusScalarDenseDoubleMatrix2D
implements PlusScalarCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    PlusScalarDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source, BigDecimal value, DenseDoubleMatrix2D target) {
        this.calc(source, value.doubleValue(), target);
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source, double value, DenseDoubleMatrix2D target) {
        if (source instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.calc(((HasColumnMajorDoubleArray1D)((Object)source)).getColumnMajorDoubleArray1D(), value, ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calc(((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D(), value, ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    target.setDouble(source.getDouble(r, c) + value, r, c);
                }
            }
        }
    }

    @Override
    private final void calc(final double[][] source, final double value, final double[][] target) {
        VerifyUtil.assertSameSize(source, target);
        if (UJMPSettings.getNumberOfThreads() > 1 && source.length >= 100 && source[0].length >= 100) {
            new PForEquidistant(0, source.length - 1, new Object[0]){

                public void step(int i) {
                    double[] tsource = source[i];
                    double[] ttarget = target[i];
                    int c = source[0].length;
                    while (--c != -1) {
                        ttarget[c] = tsource[c] + value;
                    }
                }
            };
        } else {
            double[] tsource = null;
            double[] ttarget = null;
            int r = source.length;
            while (--r != -1) {
                tsource = source[r];
                ttarget = target[r];
                int c = source[0].length;
                while (--c != -1) {
                    ttarget[c] = tsource[c] + value;
                }
            }
        }
    }

    @Override
    private final void calc(double[] source, double value, double[] target) {
        VerifyUtil.assertSameSize(source, target);
        int length = source.length;
        int i = 0;
        while (i < length) {
            target[i] = source[i] + value;
            ++i;
        }
    }
}

