/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigintegermatrix.calculation.Fibonacci;
import org.ujmp.core.booleanmatrix.DenseBooleanMatrix2D;
import org.ujmp.core.booleanmatrix.impl.DefaultDenseBooleanMatrix2D;
import org.ujmp.core.bytematrix.DenseByteMatrix2D;
import org.ujmp.core.bytematrix.impl.ArrayDenseByteMatrix2D;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.charmatrix.DenseCharMatrix2D;
import org.ujmp.core.charmatrix.impl.ArrayDenseCharMatrix2D;
import org.ujmp.core.datematrix.DenseDateMatrix2D;
import org.ujmp.core.datematrix.impl.SimpleDenseDateMatrix2D;
import org.ujmp.core.doublematrix.DenseDoubleMatrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Eye;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Ones;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Pascal;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Rand;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Randn;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Range;
import org.ujmp.core.doublematrix.calculation.general.misc.Dense2Sparse;
import org.ujmp.core.doublematrix.impl.ArrayDenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DenseFileMatrix;
import org.ujmp.core.enums.DB;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.DenseFloatMatrix2D;
import org.ujmp.core.floatmatrix.impl.ArrayDenseFloatMatrix2D;
import org.ujmp.core.genericmatrix.GenericMatrix;
import org.ujmp.core.intmatrix.DenseIntMatrix2D;
import org.ujmp.core.intmatrix.calculation.Magic;
import org.ujmp.core.intmatrix.impl.SimpleDenseIntMatrix2D;
import org.ujmp.core.io.ImportMatrix;
import org.ujmp.core.io.ImportMatrixJDBC;
import org.ujmp.core.io.LinkMatrix;
import org.ujmp.core.io.LinkMatrixJDBC;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.longmatrix.DenseLongMatrix2D;
import org.ujmp.core.longmatrix.impl.DefaultDenseLongMatrix2D;
import org.ujmp.core.longmatrix.impl.SimpleDenseLongMatrix2D;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapper.MatrixMapper;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.objectmatrix.calculation.Concatenation;
import org.ujmp.core.objectmatrix.calculation.Convert;
import org.ujmp.core.objectmatrix.calculation.Fill;
import org.ujmp.core.objectmatrix.calculation.Repmat;
import org.ujmp.core.objectmatrix.calculation.WelcomeMatrix;
import org.ujmp.core.objectmatrix.impl.EmptyMatrix;
import org.ujmp.core.objectmatrix.impl.SimpleDenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.impl.SynchronizedGenericMatrix;
import org.ujmp.core.shortmatrix.DenseShortMatrix2D;
import org.ujmp.core.shortmatrix.impl.SimpleDenseShortMatrix2D;
import org.ujmp.core.stringmatrix.DenseStringMatrix2D;
import org.ujmp.core.stringmatrix.impl.FileListMatrix;
import org.ujmp.core.stringmatrix.impl.SimpleDenseStringMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.matrices.MatrixAvailableProcessors;
import org.ujmp.core.util.matrices.MatrixMemoryUsage;
import org.ujmp.core.util.matrices.MatrixRandomSeed;
import org.ujmp.core.util.matrices.MatrixRunningThreads;
import org.ujmp.core.util.matrices.MatrixSystemEnvironment;
import org.ujmp.core.util.matrices.MatrixSystemProperties;
import org.ujmp.core.util.matrices.MatrixSystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatrixFactory {
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int Y = 0;
    public static final int X = 1;
    public static final int Z = 2;
    public static final int ALL = Integer.MAX_VALUE;
    public static final int NONE = -1;
    public static final EmptyMatrix EMPTYMATRIX = new EmptyMatrix();
    private static MatrixMapper matrixMapper = MatrixMapper.getInstance();

    public static final Matrix systemTime() {
        return new MatrixSystemTime();
    }

    public static final Matrix availableProcessors() {
        return new MatrixAvailableProcessors();
    }

    public static final Matrix memoryUsage() {
        return new MatrixMemoryUsage();
    }

    public static final Matrix range(double start, double end, double stepSize) {
        return new Range(null, start, stepSize, end).calc(Calculation.Ret.LINK);
    }

    public static final Matrix range(double start, double end) {
        return MatrixFactory.range(start, 1.0, end);
    }

    public static final Matrix randomSeed() {
        return new MatrixRandomSeed();
    }

    public static final Matrix runningThreads() {
        return new MatrixRunningThreads();
    }

    public static final Matrix systemEnvironment() {
        return new MatrixSystemEnvironment();
    }

    public static final Matrix systemProperties() {
        return new MatrixSystemProperties();
    }

    public static final Matrix horCat(Matrix ... matrices) throws MatrixException {
        return MatrixFactory.concat(1, matrices);
    }

    public static final <A> Matrix vertCat(Matrix ... matrices) throws MatrixException {
        return MatrixFactory.concat(0, matrices);
    }

    public static final <A> Matrix vertCat(Collection<Matrix> matrices) throws MatrixException {
        return MatrixFactory.concat(0, matrices);
    }

    public static final Matrix horCat(Collection<Matrix> matrices) throws MatrixException {
        return MatrixFactory.concat(1, matrices);
    }

    public static final Matrix concat(int dimension, Matrix ... matrices) throws MatrixException {
        return MatrixFactory.concat(dimension, Arrays.asList(matrices));
    }

    public static final Matrix concat(int dimension, Collection<Matrix> matrices) throws MatrixException {
        return new Concatenation(dimension, matrices).calc(Calculation.Ret.NEW);
    }

    public static final Matrix importFromArray(boolean[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(byte[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(char[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(Date[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(double[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(float[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(int[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(long[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(Object[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(short[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final Matrix importFromArray(String[] ... values) {
        return MatrixFactory.linkToArray(values).clone();
    }

    public static final DenseBooleanMatrix2D linkToArray(boolean[] ... values) {
        return new DefaultDenseBooleanMatrix2D(values);
    }

    public static final DenseBooleanMatrix2D linkToArray(boolean ... values) {
        return new DefaultDenseBooleanMatrix2D(values);
    }

    public static final DenseByteMatrix2D linkToArray(byte[] ... values) {
        return new ArrayDenseByteMatrix2D(values);
    }

    public static final DenseByteMatrix2D linkToArray(byte ... values) {
        return new ArrayDenseByteMatrix2D(values);
    }

    public static final DenseCharMatrix2D linkToArray(char[] ... values) {
        return new ArrayDenseCharMatrix2D(values);
    }

    public static final DenseCharMatrix2D linkToArray(char ... values) {
        return new ArrayDenseCharMatrix2D(values);
    }

    public static final DenseDateMatrix2D linkToArray(Date[] ... values) {
        return new SimpleDenseDateMatrix2D(values);
    }

    public static final DenseDateMatrix2D linkToArray(Date ... values) {
        return new SimpleDenseDateMatrix2D(values);
    }

    public static final DenseDoubleMatrix2D linkToArray(double[] ... values) {
        return new ArrayDenseDoubleMatrix2D(values);
    }

    public static final DenseDoubleMatrix2D linkToArray(double ... values) {
        return new ArrayDenseDoubleMatrix2D(values);
    }

    public static final DenseFloatMatrix2D linkToArray(float[] ... values) {
        return new ArrayDenseFloatMatrix2D(values);
    }

    public static final DenseFloatMatrix2D linkToArray(float ... values) {
        return new ArrayDenseFloatMatrix2D(values);
    }

    public static final DenseIntMatrix2D linkToArray(int[] ... values) {
        return new SimpleDenseIntMatrix2D(values);
    }

    public static final DenseIntMatrix2D linkToArray(int ... values) {
        return new SimpleDenseIntMatrix2D(values);
    }

    public static final DenseLongMatrix2D linkToArray(long[] ... values) {
        return new SimpleDenseLongMatrix2D(values);
    }

    public static final DenseLongMatrix2D linkToArray(long ... values) {
        return new DefaultDenseLongMatrix2D(values);
    }

    public static final DenseObjectMatrix2D linkToArray(Object[] ... values) {
        return new SimpleDenseObjectMatrix2D(values);
    }

    public static final DenseObjectMatrix2D linkToArray(Object ... values) {
        return new SimpleDenseObjectMatrix2D(new Object[][]{values});
    }

    public static final DenseShortMatrix2D linkToArray(short[] ... values) {
        return new SimpleDenseShortMatrix2D(values);
    }

    public static final DenseShortMatrix2D linkToArray(short ... values) {
        return new SimpleDenseShortMatrix2D(new short[][]{values});
    }

    public static final DenseStringMatrix2D linkToArray(String[] ... values) {
        return new SimpleDenseStringMatrix2D(values);
    }

    public static final DenseStringMatrix2D linkToArray(String ... values) {
        return new SimpleDenseStringMatrix2D(new String[][]{values});
    }

    public static final Matrix copyFromMatrix(Matrix matrix) throws MatrixException {
        return Convert.calcNew(matrix);
    }

    public static final Matrix randn(long ... size) throws MatrixException {
        return Randn.calc(size);
    }

    public static final Matrix randn(ValueType valueType, long ... size) throws MatrixException {
        return Randn.calc(valueType, size);
    }

    public static final Matrix rand(long ... size) throws MatrixException {
        return Rand.calc(size);
    }

    public static final Matrix rand(ValueType valueType, long ... size) throws MatrixException {
        return Rand.calc(valueType, size);
    }

    public static final Matrix correlatedColumns(int rows, int columns, double correlationFactor) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(rows, columns);
        Matrix orig = MatrixFactory.randn(rows, 1L);
        int c = 0;
        while (c < columns) {
            Matrix rand = MatrixFactory.randn(rows, 1L);
            int r = 0;
            while (r < rows) {
                ret.setAsDouble(orig.getAsDouble(r, 0L) * correlationFactor + (1.0 - correlationFactor) * rand.getAsDouble(r, 0L), r, c);
                ++r;
            }
            ++c;
        }
        return ret;
    }

    public static final DenseDoubleMatrix2D linkToValue(double value) {
        return new ArrayDenseDoubleMatrix2D(new double[][]{{value}});
    }

    public static final DenseIntMatrix2D linkToValue(int value) {
        return new SimpleDenseIntMatrix2D(new int[][]{{value}});
    }

    public static final DenseCharMatrix2D linkToValue(char value) {
        return new ArrayDenseCharMatrix2D(new char[][]{{value}});
    }

    public static final DenseDateMatrix2D linkToValue(Date value) {
        return new SimpleDenseDateMatrix2D(new Date[][]{{value}});
    }

    public static final DenseBooleanMatrix2D linkToValue(boolean value) {
        return new DefaultDenseBooleanMatrix2D(new boolean[][]{{value}});
    }

    public static final DenseByteMatrix2D linkToValue(byte value) {
        return new ArrayDenseByteMatrix2D(new byte[][]{{value}});
    }

    public static final DenseShortMatrix2D linkToValue(short value) {
        return new SimpleDenseShortMatrix2D(new short[][]{{value}});
    }

    public static final DenseStringMatrix2D linkToValue(String value) {
        return new SimpleDenseStringMatrix2D(new String[][]{{value}});
    }

    public static final DenseLongMatrix2D linkToValue(long value) {
        return new SimpleDenseLongMatrix2D(new long[][]{{value}});
    }

    public static final Matrix linkToValue(Object value) {
        if (value == null) {
            return MatrixFactory.emptyMatrix();
        }
        if (value instanceof Double) {
            return new ArrayDenseDoubleMatrix2D(new double[][]{{(Double)value}});
        }
        if (value instanceof Integer) {
            return new SimpleDenseIntMatrix2D(new int[][]{{(Integer)value}});
        }
        if (value instanceof Float) {
            return new ArrayDenseFloatMatrix2D(new float[][]{{((Float)value).floatValue()}});
        }
        if (value instanceof String) {
            return new SimpleDenseStringMatrix2D(new String[][]{{(String)value}});
        }
        if (value instanceof Short) {
            return new SimpleDenseShortMatrix2D(new short[][]{{(Short)value}});
        }
        if (value instanceof Byte) {
            return new ArrayDenseByteMatrix2D(new byte[][]{{(Byte)value}});
        }
        if (value instanceof Boolean) {
            return new DefaultDenseBooleanMatrix2D(new boolean[][]{{(Boolean)value}});
        }
        if (value instanceof Long) {
            return new SimpleDenseLongMatrix2D(new long[][]{{(Long)value}});
        }
        return new SimpleDenseObjectMatrix2D(new Object[][]{{value}});
    }

    public static Matrix zeros(ValueType valueType, long ... size) throws MatrixException {
        return MatrixFactory.dense(valueType, size);
    }

    public static Matrix dense(ValueType valueType, long ... size) throws MatrixException {
        if (ValueType.DOUBLE.equals((Object)valueType)) {
            return MatrixFactory.dense(size);
        }
        try {
            Constructor<?> con = null;
            block1 : switch (size.length) {
                case 0: {
                    throw new MatrixException("Size not defined");
                }
                case 1: {
                    throw new MatrixException("Size must be at least 2-dimensional");
                }
                case 2: {
                    switch (valueType) {
                        case BOOLEAN: {
                            con = matrixMapper.getDenseBooleanMatrix2DConstructor();
                            break block1;
                        }
                        case BYTE: {
                            con = matrixMapper.getDenseByteMatrix2DConstructor();
                            break block1;
                        }
                        case CHAR: {
                            con = matrixMapper.getDenseCharMatrix2DConstructor();
                            break block1;
                        }
                        case DATE: {
                            con = matrixMapper.getDenseDateMatrix2DConstructor();
                            break block1;
                        }
                        case FLOAT: {
                            con = matrixMapper.getDenseFloatMatrix2DConstructor();
                            break block1;
                        }
                        case INT: {
                            con = matrixMapper.getDenseIntMatrix2DConstructor();
                            break block1;
                        }
                        case LONG: {
                            con = matrixMapper.getDenseLongMatrix2DConstructor();
                            break block1;
                        }
                        case OBJECT: {
                            con = matrixMapper.getDenseObjectMatrix2DConstructor();
                            break block1;
                        }
                        case SHORT: {
                            con = matrixMapper.getDenseShortMatrix2DConstructor();
                            break block1;
                        }
                        case STRING: {
                            con = matrixMapper.getDenseStringMatrix2DConstructor();
                            break block1;
                        }
                        case BIGINTEGER: {
                            con = matrixMapper.getDenseBigIntegerMatrix2DConstructor();
                            break block1;
                        }
                        case BIGDECIMAL: {
                            con = matrixMapper.getDenseBigDecimalMatrix2DConstructor();
                            break block1;
                        }
                    }
                    throw new MatrixException("entry type not yet supported: " + (Object)((Object)valueType));
                }
                default: {
                    switch (valueType) {
                        case BOOLEAN: {
                            con = matrixMapper.getDenseBooleanMatrixMultiDConstructor();
                            break block1;
                        }
                        case BYTE: {
                            con = matrixMapper.getDenseByteMatrixMultiDConstructor();
                            break block1;
                        }
                        case CHAR: {
                            con = matrixMapper.getDenseCharMatrixMultiDConstructor();
                            break block1;
                        }
                        case DATE: {
                            con = matrixMapper.getDenseDateMatrixMultiDConstructor();
                            break block1;
                        }
                        case FLOAT: {
                            con = matrixMapper.getDenseFloatMatrixMultiDConstructor();
                            break block1;
                        }
                        case INT: {
                            con = matrixMapper.getDenseIntMatrixMultiDConstructor();
                            break block1;
                        }
                        case LONG: {
                            con = matrixMapper.getDenseLongMatrixMultiDConstructor();
                            break block1;
                        }
                        case OBJECT: {
                            con = matrixMapper.getDenseObjectMatrixMultiDConstructor();
                            break block1;
                        }
                        case SHORT: {
                            con = matrixMapper.getDenseShortMatrixMultiDConstructor();
                            break block1;
                        }
                        case STRING: {
                            con = matrixMapper.getDenseStringMatrixMultiDConstructor();
                            break block1;
                        }
                        case BIGINTEGER: {
                            con = matrixMapper.getDenseBigIntegerMatrixMultiDConstructor();
                            break block1;
                        }
                        case BIGDECIMAL: {
                            con = matrixMapper.getDenseBigDecimalMatrixMultiDConstructor();
                            break block1;
                        }
                    }
                    throw new MatrixException("entry type not yet supported: " + (Object)((Object)valueType));
                }
            }
            return (Matrix)con.newInstance(new Object[]{size});
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public static Matrix ones(long ... size) throws MatrixException {
        return Ones.calc(size);
    }

    public static Matrix fill(Object value, long ... size) throws MatrixException {
        return Fill.calc(value, size);
    }

    public static Matrix ones(ValueType valueType, long ... size) throws MatrixException {
        return Ones.calc(valueType, size);
    }

    public static Matrix eye(long ... size) throws MatrixException {
        return Eye.calc(size);
    }

    public static Matrix magic(int size) throws MatrixException {
        return Magic.magic(size);
    }

    public static Matrix pascal(long ... size) throws MatrixException {
        return new Pascal(MatrixFactory.zeros(ValueType.BIGINTEGER, size)).calcOrig();
    }

    public static Matrix fibonacci(int count) throws MatrixException {
        return Fibonacci.calc(count);
    }

    public static Matrix eye(ValueType valueType, long ... size) throws MatrixException {
        return Eye.calc(valueType, size);
    }

    public static final Matrix createVectorForClass(int classID, int classCount) throws MatrixException {
        Matrix matrix = MatrixFactory.dense(classCount, 1L);
        matrix.setAsDouble(1.0, classID, 0L);
        return matrix;
    }

    public static final FileListMatrix linkToDir(String dir) {
        return new FileListMatrix(dir);
    }

    public static final Matrix linkToMap(Map<?, ?> map) {
        if (map instanceof Matrix) {
            return (Matrix)((Object)map);
        }
        return new DefaultMapMatrix(map);
    }

    public static final Matrix linkToCollection(Collection<?> list) {
        if (list instanceof Matrix) {
            return (Matrix)((Object)list);
        }
        return new DefaultListMatrix<Object>(new Object[]{list});
    }

    public static Matrix importFromStream(FileFormat format, InputStream stream, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromStream(format, stream, parameters);
    }

    public static Matrix importFromURL(FileFormat format, URL url, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromURL(format, url, parameters);
    }

    public static Matrix importFromURL(FileFormat format, String url, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromURL(format, url, parameters);
    }

    public static Matrix importFromString(FileFormat format, String string, Object ... parameters) throws MatrixException {
        return ImportMatrix.fromString(format, string, (Object)parameters);
    }

    public static final <T> SynchronizedGenericMatrix<T> synchronizedMatrix(GenericMatrix<T> matrix) {
        return new SynchronizedGenericMatrix(matrix);
    }

    public static final DenseDoubleMatrix linkToBinaryFile(String filename, long ... size) throws IOException {
        return new DenseFileMatrix(new File(filename), size);
    }

    public static final ObjectMatrix2D linkToJDBC(String url, String sqlStatement, String username, String password) {
        return LinkMatrixJDBC.toDatabase(url, sqlStatement, username, password);
    }

    public static final ObjectMatrix2D linkToJDBC(DB type, String host, int port, String database, String sqlStatement, String username, String password) {
        return LinkMatrixJDBC.toDatabase(type, host, port, database, sqlStatement, username, password);
    }

    public static final ObjectMatrix2D importFromJDBC(String url, String sqlStatement, String username, String password) {
        return ImportMatrixJDBC.fromDatabase(url, sqlStatement, username, password);
    }

    public static final ObjectMatrix2D importFromJDBC(DB type, String host, int port, String database, String sqlStatement, String username, String password) {
        return ImportMatrixJDBC.fromDatabase(type, host, port, database, sqlStatement, username, password);
    }

    public static final Matrix sparse(long ... size) throws MatrixException {
        return MatrixFactory.sparse(ValueType.DOUBLE, size);
    }

    public static final Matrix sparse(Matrix indices) {
        return Dense2Sparse.calc(indices);
    }

    public static final Matrix sparse(ValueType valueType, long ... size) throws MatrixException {
        try {
            Constructor<?> con = null;
            block1 : switch (size.length) {
                case 0: {
                    throw new MatrixException("Size not defined");
                }
                case 1: {
                    throw new MatrixException("Size must be at least 2-dimensional");
                }
                case 2: {
                    switch (valueType) {
                        case BOOLEAN: {
                            con = matrixMapper.getSparseBooleanMatrix2DConstructor();
                            break block1;
                        }
                        case BYTE: {
                            con = matrixMapper.getSparseByteMatrix2DConstructor();
                            break block1;
                        }
                        case CHAR: {
                            con = matrixMapper.getSparseCharMatrix2DConstructor();
                            break block1;
                        }
                        case DATE: {
                            con = matrixMapper.getSparseDateMatrix2DConstructor();
                            break block1;
                        }
                        case DOUBLE: {
                            con = matrixMapper.getSparseDoubleMatrix2DConstructor();
                            break block1;
                        }
                        case FLOAT: {
                            con = matrixMapper.getSparseFloatMatrix2DConstructor();
                            break block1;
                        }
                        case INT: {
                            con = matrixMapper.getSparseIntMatrix2DConstructor();
                            break block1;
                        }
                        case LONG: {
                            con = matrixMapper.getSparseLongMatrix2DConstructor();
                            break block1;
                        }
                        case OBJECT: {
                            con = matrixMapper.getSparseObjectMatrix2DConstructor();
                            break block1;
                        }
                        case SHORT: {
                            con = matrixMapper.getSparseShortMatrix2DConstructor();
                            break block1;
                        }
                        case STRING: {
                            con = matrixMapper.getSparseStringMatrix2DConstructor();
                            break block1;
                        }
                        case BIGINTEGER: {
                            con = matrixMapper.getSparseBigIntegerMatrix2DConstructor();
                            break block1;
                        }
                        case BIGDECIMAL: {
                            con = matrixMapper.getSparseBigDecimalMatrix2DConstructor();
                            break block1;
                        }
                    }
                    throw new MatrixException("entry type not supported: " + (Object)((Object)valueType));
                }
                default: {
                    switch (valueType) {
                        case BOOLEAN: {
                            con = matrixMapper.getSparseBooleanMatrixMultiDConstructor();
                            break block1;
                        }
                        case BYTE: {
                            con = matrixMapper.getSparseByteMatrixMultiDConstructor();
                            break block1;
                        }
                        case CHAR: {
                            con = matrixMapper.getSparseCharMatrixMultiDConstructor();
                            break block1;
                        }
                        case DATE: {
                            con = matrixMapper.getSparseDateMatrixMultiDConstructor();
                            break block1;
                        }
                        case DOUBLE: {
                            con = matrixMapper.getSparseDoubleMatrixMultiDConstructor();
                            break block1;
                        }
                        case FLOAT: {
                            con = matrixMapper.getSparseFloatMatrixMultiDConstructor();
                            break block1;
                        }
                        case INT: {
                            con = matrixMapper.getSparseIntMatrixMultiDConstructor();
                            break block1;
                        }
                        case LONG: {
                            con = matrixMapper.getSparseLongMatrixMultiDConstructor();
                            break block1;
                        }
                        case OBJECT: {
                            con = matrixMapper.getSparseObjectMatrixMultiDConstructor();
                            break block1;
                        }
                        case SHORT: {
                            con = matrixMapper.getSparseShortMatrixMultiDConstructor();
                            break block1;
                        }
                        case STRING: {
                            con = matrixMapper.getSparseStringMatrixMultiDConstructor();
                            break block1;
                        }
                        case BIGINTEGER: {
                            con = matrixMapper.getSparseBigIntegerMatrixMultiDConstructor();
                            break block1;
                        }
                        case BIGDECIMAL: {
                            con = matrixMapper.getSparseBigDecimalMatrixMultiDConstructor();
                            break block1;
                        }
                    }
                    throw new MatrixException("entry type not  supported: " + (Object)((Object)valueType));
                }
            }
            return (Matrix)con.newInstance(new Object[]{size});
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    public static Matrix zeros(long ... size) throws MatrixException {
        return MatrixFactory.dense(size);
    }

    public static Matrix dense(long ... size) throws MatrixException {
        return DenseMatrix.factory.zeros(size);
    }

    public static final Matrix linkToFile(FileFormat format, File file, Object ... parameters) throws MatrixException, IOException {
        return LinkMatrix.toFile(format, file, parameters);
    }

    public static final Matrix importFromFile(String filename, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromFile(new File(filename), parameters);
    }

    public static final Matrix importFromFile(File file, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromFile(file, parameters);
    }

    public static final Matrix importFromFile(FileFormat format, String file, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromFile(format, new File(file), parameters);
    }

    public static final Matrix importFromFile(FileFormat format, File file, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromFile(format, file, parameters);
    }

    public static final Matrix importFromClipboard(FileFormat format, Object ... parameters) throws MatrixException {
        return ImportMatrix.fromClipboard(format, parameters);
    }

    public static final Matrix SUNSPOTDATASET() {
        return MatrixFactory.linkToArray(5.0, 11.0, 16.0, 23.0, 36.0, 58.0, 29.0, 20.0, 10.0, 8.0, 3.0, 0.0, 0.0, 2.0, 11.0, 27.0, 47.0, 63.0, 60.0, 39.0, 28.0, 26.0, 22.0, 11.0, 21.0, 40.0, 78.0, 122.0, 103.0, 73.0, 47.0, 35.0, 11.0, 5.0, 16.0, 34.0, 70.0, 81.0, 111.0, 101.0, 73.0, 40.0, 20.0, 16.0, 5.0, 11.0, 22.0, 40.0, 60.0, 80.9, 83.4, 47.7, 47.8, 30.7, 12.2, 9.6, 10.2, 32.4, 47.6, 54.0, 62.9, 85.9, 61.2, 45.1, 36.4, 20.9, 11.4, 37.8, 69.8, 106.1, 100.8, 81.6, 66.5, 34.8, 30.6, 7.0, 19.8, 92.5, 154.4, 125.9, 84.8, 68.1, 38.5, 22.8, 10.2, 24.1, 82.9, 132.0, 130.9, 118.1, 89.9, 66.6, 60.0, 46.9, 41.0, 21.3, 16.0, 6.4, 4.1, 6.8, 14.5, 34.0, 45.0, 43.1, 47.5, 42.2, 28.1, 10.1, 8.1, 2.5, 0.0, 1.4, 5.0, 12.2, 13.9, 35.4, 45.8, 41.1, 30.1, 23.9, 15.6, 6.6, 4.0, 1.8, 8.5, 16.6, 36.3, 49.6, 64.2, 67.0, 70.9, 47.8, 27.5, 8.5, 13.2, 56.9, 121.5, 138.3, 103.2, 85.7, 64.6, 36.7, 24.2, 10.7, 15.0, 40.1, 61.5, 98.5, 124.7, 96.3, 66.6, 64.5, 54.1, 39.0, 20.6, 6.7, 4.3, 22.7, 54.8, 93.8, 95.8, 77.2, 59.1, 44.0, 47.0, 30.5, 16.3, 7.3, 37.6, 74.0, 139.0, 111.2, 101.6, 66.2, 44.7, 17.0, 11.3, 12.4, 3.4, 6.0, 32.3, 54.3, 59.7, 63.7, 63.5, 52.2, 25.4, 13.1, 6.8, 6.3, 7.1, 35.6, 73.0, 85.1, 78.0, 64.0, 41.8, 26.2, 26.7, 12.1, 9.5, 2.7, 5.0, 24.4, 42.0, 63.5, 53.8, 62.0, 48.5, 43.9, 18.6, 5.7, 3.6, 1.4, 9.6, 47.4, 57.1, 103.9, 80.6, 63.6, 37.6, 26.1, 14.2, 5.8, 16.7, 44.3, 63.9, 69.0, 77.8, 64.9, 35.7, 21.2, 11.1, 5.7, 8.7, 36.1, 79.7, 114.4, 109.6, 88.8, 67.8, 47.5, 30.6, 16.3, 9.6, 33.2, 92.6, 151.6, 136.3, 134.7, 83.9, 69.4, 31.5, 13.9, 4.4, 38.0, 141.7, 190.2, 184.8, 159.0, 112.3, 53.9, 37.5, 27.9, 10.2, 15.1, 47.0, 93.8, 105.9, 105.5, 104.5, 66.6, 68.9, 38.0, 34.5, 15.5, 12.6, 27.5, 92.5, 155.4, 154.6, 140.4, 115.9, 66.6, 45.9, 17.9, 13.4, 29.3);
    }

    public static final Matrix emptyMatrix() {
        return EMPTYMATRIX;
    }

    public static MatrixMapper getMatrixMapper() {
        return matrixMapper;
    }

    public static void setMatrixMapper(MatrixMapper matrixMapper) {
        MatrixFactory.matrixMapper = matrixMapper;
    }

    public static Matrix repmat(Matrix matrix, long ... count) {
        return new Repmat(matrix, count).calc(Calculation.Ret.LINK);
    }

    public static Matrix welcomeMatrix() {
        return new WelcomeMatrix();
    }

    public static Matrix like(Matrix matrix) {
        if (matrix.isSparse()) {
            return MatrixFactory.sparse(matrix.getSize());
        }
        return MatrixFactory.dense(matrix.getSize());
    }

    public static Matrix like(Matrix matrix, long ... size) {
        if (matrix.isSparse()) {
            return SparseMatrix.factory.zeros(size);
        }
        return DenseMatrix.factory.zeros(size);
    }

    public static Matrix vertCat(Matrix row, long rowCount) {
        Object[] matrices = new Matrix[(int)rowCount];
        Arrays.fill(matrices, row);
        return MatrixFactory.vertCat((Matrix[])matrices);
    }

    public static Matrix horCat(Matrix column, long columnCount) {
        Object[] matrices = new Matrix[(int)columnCount];
        Arrays.fill(matrices, column);
        return MatrixFactory.horCat((Matrix[])matrices);
    }

    public static Matrix sequence(double start, double end) {
        return MatrixFactory.sequence(start, end, 1.0);
    }

    public static Matrix sequence(double start, double end, double stepsize) {
        return MatrixFactory.linkToArray(MathUtil.sequenceDouble(start, end, stepsize));
    }
}

