/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import java.util.Date;

public class MatFileHeader {
    private static String DEFAULT_DESCRIPTIVE_TEXT = "MATLAB 5.0 MAT-file, Platform: " + System.getProperty("os.name") + ", CREATED on: ";
    private static int DEFAULT_VERSION = 256;
    private static byte[] DEFAULT_ENDIAN_INDICATOR = new byte[]{77, 73};
    private int version;
    private String description;
    private byte[] endianIndicator;

    public MatFileHeader(String string, int n, byte[] byArray) {
        this.description = string;
        this.version = n;
        this.endianIndicator = byArray;
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getEndianIndicator() {
        return this.endianIndicator;
    }

    public int getVersion() {
        return this.version;
    }

    public static MatFileHeader createHeader() {
        return new MatFileHeader(DEFAULT_DESCRIPTIVE_TEXT + new Date().toString(), DEFAULT_VERSION, DEFAULT_ENDIAN_INDICATOR);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append("desriptive text: " + this.description);
        stringBuffer.append(", version: " + this.version);
        stringBuffer.append(", endianIndicator: " + new String(this.endianIndicator));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

