/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.editor.MatrixTableCellEditor;
import org.ujmp.gui.menu.MatrixPopupMenu;
import org.ujmp.gui.panels.RowHeaderRenderer;
import org.ujmp.gui.panels.RowListModel;
import org.ujmp.gui.renderer.MatrixValueTableCellRenderer;

public class MatrixTableEditorPanel
extends JPanel
implements TableModelListener,
MouseListener,
KeyListener,
ListSelectionListener {
    private static final long serialVersionUID = -1794955656888362574L;
    private MatrixGUIObject dataModel = null;
    private final TableModel emptyModel = new DefaultTableModel();
    private JTable jTable = null;
    private JList rowHeader = null;
    private JScrollPane scrollPane = null;
    private boolean scroll = true;

    public MatrixTableEditorPanel(MatrixGUIObject m) {
        this();
        this.setMatrix(m);
    }

    public MatrixTableEditorPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Matrix Editor"));
        this.setLayout(new GridBagLayout());
        this.jTable = new JTable();
        this.jTable.setAutoResizeMode(0);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setSelectionMode(1);
        this.jTable.setColumnSelectionAllowed(true);
        this.jTable.setDefaultRenderer(Object.class, new MatrixValueTableCellRenderer());
        this.jTable.setDefaultEditor(Object.class, new MatrixTableCellEditor());
        this.jTable.addMouseListener(this);
        this.jTable.addKeyListener(this);
        this.jTable.getSelectionModel().addListSelectionListener(this);
        this.rowHeader = new JList();
        this.rowHeader.setOpaque(true);
        this.rowHeader.setFixedCellHeight(this.jTable.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.jTable));
        this.scrollPane = new JScrollPane(this.jTable);
        this.addMouseListener(this);
        this.add((Component)this.jTable.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void tableChanged(TableModelEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            int row = this.jTable.rowAtPoint(e.getPoint());
            int col = this.jTable.columnAtPoint(e.getPoint());
            MatrixPopupMenu popup = new MatrixPopupMenu(null, this.dataModel, row, col);
            popup.show(this.jTable, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.scroll = false;
    }

    public void mouseReleased(MouseEvent e) {
        this.scroll = true;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.scroll && !e.getValueIsAdjusting()) {
            int minRow = this.jTable.getSelectionModel().getMinSelectionIndex();
            int minCol = this.jTable.getColumnModel().getSelectionModel().getMinSelectionIndex();
            int maxRow = this.jTable.getSelectionModel().getMaxSelectionIndex();
            int maxCol = this.jTable.getColumnModel().getSelectionModel().getMaxSelectionIndex();
            if (minRow == maxRow && minCol == maxCol) {
                JViewport viewport = (JViewport)this.jTable.getParent();
                Rectangle rect = this.jTable.getCellRect(minRow, minCol, true);
                Rectangle viewRect = viewport.getViewRect();
                rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                int centerX = (viewRect.width - rect.width) / 2;
                int centerY = (viewRect.height - rect.height) / 2;
                if (rect.x < centerX) {
                    centerX = -centerX;
                }
                if (rect.y < centerY) {
                    centerY = -centerY;
                }
                rect.translate(centerX, centerY);
                viewport.scrollRectToVisible(rect);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
    }

    public void setMatrix(MatrixGUIObject m) {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.getRowSelectionModel().removeListSelectionListener(this);
            this.dataModel.getColumnSelectionModel().removeListSelectionListener(this);
        }
        this.dataModel = m;
        if (this.dataModel != null) {
            this.jTable.setModel(this.dataModel);
            this.jTable.setSelectionModel(this.dataModel.getRowSelectionModel());
            this.jTable.getColumnModel().setSelectionModel(this.dataModel.getColumnSelectionModel());
            this.dataModel.getRowSelectionModel().addListSelectionListener(this);
            this.dataModel.getColumnSelectionModel().addListSelectionListener(this);
            if (this.dataModel.getRowCount() <= 100000) {
                RowListModel rowListModel = new RowListModel(this.dataModel);
                this.rowHeader.setModel(rowListModel);
                this.scrollPane.setRowHeaderView(this.rowHeader);
            } else {
                this.scrollPane.setRowHeaderView(null);
            }
        } else {
            this.jTable.setModel(this.emptyModel);
            this.scrollPane.setRowHeaderView(null);
        }
    }
}

