/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ehcache;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.ujmp.core.collections.AbstractMap;
import org.ujmp.core.interfaces.Erasable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheMap<K, V>
extends AbstractMap<K, V>
implements Erasable,
Flushable,
Closeable {
    private static final long serialVersionUID = -2405059234958626645L;
    private int maxElementsInMemory = 1000;
    private final int maxElementsOnDisk = 0x7FFFFFFE;
    private boolean overflowToDisk = true;
    private final boolean eternal = true;
    private final boolean diskPersistent = true;
    private transient File diskStorePath = null;
    private transient String name = null;
    private final transient RegisteredEventListeners registeredEventListeners = null;
    private final int timeToLiveSeconds = 0x7FFFFFFE;
    private final int timeToIdleSeconds = 120;
    private final int diskSpoolBufferSizeMB = 16;
    private final int diskExpiryThreadIntervalSeconds = 300;
    private final MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LFU;
    private transient CacheManager manager = null;
    private transient Cache cache = null;
    private static long runningId = System.currentTimeMillis();
    private final BootstrapCacheLoader bootstrapCacheLoader = null;

    public EhcacheMap() throws IOException {
        this(null);
    }

    public EhcacheMap(String name) throws IOException {
        this(name, null, true);
    }

    public EhcacheMap(boolean overFlowToDisk) throws IOException {
        this(null, null, overFlowToDisk);
    }

    public EhcacheMap(String name, boolean overFlowToDisk) throws IOException {
        this(name, null, overFlowToDisk);
    }

    public EhcacheMap(String name, File path, boolean overFlowToDisk) throws IOException {
        ++runningId;
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        this.diskStorePath = path;
        this.overflowToDisk = overFlowToDisk;
        this.name = name;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "ehcache" + runningId;
        }
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public File getPath() {
        if (this.diskStorePath == null) {
            try {
                this.diskStorePath = File.createTempFile(this.getName(), ".tmp");
                this.diskStorePath.delete();
                this.diskStorePath.mkdir();
                new File(this.diskStorePath + System.getProperty("file.separator") + this.getName() + ".data").deleteOnExit();
                new File(this.diskStorePath + System.getProperty("file.separator") + this.getName() + ".index").deleteOnExit();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.diskStorePath;
    }

    private CacheManager getCacheManager() {
        if (this.manager == null) {
            Configuration config = new Configuration();
            CacheConfiguration cacheconfig = new CacheConfiguration(this.getName(), this.maxElementsInMemory);
            cacheconfig.setDiskExpiryThreadIntervalSeconds(300L);
            cacheconfig.setDiskPersistent(true);
            cacheconfig.setEternal(true);
            cacheconfig.setMaxElementsOnDisk(0x7FFFFFFE);
            cacheconfig.setMemoryStoreEvictionPolicyFromObject(this.memoryStoreEvictionPolicy);
            cacheconfig.setOverflowToDisk(this.overflowToDisk);
            cacheconfig.setTimeToIdleSeconds(120L);
            cacheconfig.setTimeToLiveSeconds(0x7FFFFFFEL);
            DiskStoreConfiguration diskStoreConfigurationParameter = new DiskStoreConfiguration();
            diskStoreConfigurationParameter.setPath(this.getPath().getAbsolutePath());
            config.addDiskStore(diskStoreConfigurationParameter);
            config.setDefaultCacheConfiguration(cacheconfig);
            this.manager = new CacheManager(config);
        }
        return this.manager;
    }

    private Cache getCache() {
        if (this.cache == null) {
            Cache c = new Cache(this.getName(), this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, this.getPath().getAbsolutePath(), true, 0x7FFFFFFEL, 120L, true, 300L, this.registeredEventListeners, this.bootstrapCacheLoader, 0x7FFFFFFE, 16);
            this.getCacheManager().addCache(c);
            this.cache = this.getCacheManager().getCache(this.getName());
        }
        return this.cache;
    }

    @Override
    public void clear() {
        this.getCache().removeAll();
        this.getCache().flush();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCache().isKeyInCache(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getCache().isValueInCache(value);
    }

    @Override
    public synchronized V get(Object key) {
        Element e = this.getCache().get(key);
        if (e != null) {
            return (V)e.getValue();
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return new HashSet(this.getCache().getKeys());
    }

    @Override
    public synchronized V put(K key, V value) {
        Element e = new Element(key, value);
        this.getCache().put(e);
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        this.getCache().remove(key);
        return null;
    }

    @Override
    public int size() {
        return this.getCache().getSize();
    }

    public void finalize() {
        try {
            this.erase();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void erase() throws IOException {
        this.close();
        this.getCacheManager().shutdown();
    }

    @Override
    public void flush() throws IOException {
        this.getCache().flush();
    }

    @Override
    public void close() throws IOException {
        this.getCacheManager().removeCache(this.getCache().getName());
    }
}

