/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.concurrent.UJMPThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UJMPThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final ThreadLocal<ThreadPoolExecutor> executors = new ThreadLocal();

    public UJMPThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, int priority, boolean deamon) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new UJMPThreadFactory(name, priority, deamon));
    }

    public UJMPThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize) {
        this(name, corePoolSize, maximumPoolSize, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public UJMPThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(name, maximumPoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, 5, true);
    }

    public static final ThreadPoolExecutor getInstance() {
        return UJMPThreadPoolExecutor.getInstance(UJMPSettings.getNumberOfThreads());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ThreadPoolExecutor getInstance(int maximumPoolSize) {
        ThreadPoolExecutor es = executors.get();
        if (es == null) {
            ThreadLocal<ThreadPoolExecutor> threadLocal = executors;
            synchronized (threadLocal) {
                es = new UJMPThreadPoolExecutor(Thread.currentThread().getName(), 0, maximumPoolSize);
                executors.set(es);
            }
        }
        return es;
    }
}

