/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.treematrix;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ujmp.core.collections.ArrayIndexList;
import org.ujmp.core.treematrix.AbstractTreeMatrix;
import org.ujmp.core.treematrix.NameAndValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTreeMatrix
extends AbstractTreeMatrix {
    private static final long serialVersionUID = -7343649063964349539L;
    private final List<Object> objects = new ArrayIndexList<Object>();
    private Object root = null;
    private final Map<Object, List<Object>> childrenMap = new HashMap<Object, List<Object>>();
    private final Map<Object, Object> parentMap = new HashMap<Object, Object>();

    public ObjectTreeMatrix(Object o) {
        this.root = new NameAndValue("Root", o);
        this.addSuperclass("Root", o);
        this.addFields("Root", o);
    }

    @Override
    public Map<Object, Object> getParentMap() {
        return this.parentMap;
    }

    private void addSuperclass(String name, Object o) {
        Class<?> superclass = o.getClass().getSuperclass();
        if (superclass != null && !Object.class.equals(superclass) && !Number.class.equals(superclass)) {
            this.addSuperclass("super", superclass);
            this.addFields("super", superclass);
            this.addChild(new NameAndValue(name, o), new NameAndValue("super", superclass));
        }
    }

    private void addFields(String name, Object o) {
        if (o == null) {
            return;
        }
        NameAndValue no = new NameAndValue(name, o);
        if (this.objects.contains(no)) {
            return;
        }
        this.objects.add(no);
        this.addSuperclass(name, o);
        if (o instanceof Long) {
            return;
        }
        if (o instanceof Integer) {
            return;
        }
        if (o instanceof String) {
            return;
        }
        if (o instanceof Boolean) {
            return;
        }
        if (o instanceof Float) {
            return;
        }
        if (o instanceof Short) {
            return;
        }
        if (o instanceof Byte) {
            return;
        }
        Field[] fields = o.getClass().getDeclaredFields();
        if (fields != null) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                try {
                    f.setAccessible(true);
                    Object child = f.get(o);
                    System.out.println(String.valueOf(f.getName()) + "=" + child);
                    this.addFields(f.getName(), child);
                    this.addChild(new NameAndValue(name, o), new NameAndValue(f.getName(), child));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    @Override
    public List<Object> getChildren(Object o) {
        List<Object> children = this.childrenMap.get(o);
        if (children == null) {
            children = new LinkedList<Object>();
            this.childrenMap.put(o, children);
        }
        return children;
    }

    @Override
    public Collection<Object> getObjectList() {
        return this.objects;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Object o) {
        this.root = o;
    }
}

