/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.io.DelayedContentMatrix;

public abstract class LinkMatrix {
    public static Matrix toFile(FileFormat format, File file, Object ... parameters) throws MatrixException, IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.LinkMatrix" + format.name());
            Method m = c.getMethod("toFile", File.class, Object[].class);
            Matrix matrix = (Matrix)m.invoke(null, file, parameters);
            return matrix;
        }
        catch (ClassNotFoundException e) {
            try {
                return new DelayedContentMatrix(format, file, parameters);
            }
            catch (ClassCastException ex) {
                throw new MatrixException("format not supported: " + (Object)((Object)format), e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("could not import", e);
        }
    }
}

