/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.BlockDenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.BlockMatrixLayout;
import org.ujmp.core.doublematrix.impl.BlockMultiply;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;
import org.ujmp.core.util.concurrent.UJMPThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesDenseDoubleMatrix2D
implements MtimesCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    MtimesDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
        VerifyUtil.assertTrue(source1 != null, "a == null");
        VerifyUtil.assertTrue(source2 != null, "b == null");
        VerifyUtil.assertTrue(target != null, "c == null");
        VerifyUtil.assertTrue(source1.getColumnCount() == source2.getRowCount(), "a.cols!=b.rows");
        VerifyUtil.assertTrue(source1.getRowCount() == target.getRowCount(), "a.rows!=c.rows");
        VerifyUtil.assertTrue(source2.getColumnCount() == target.getColumnCount(), "a.cols!=c.cols");
        if (source1.getRowCount() >= (long)Mtimes.THRESHOLD && source1.getColumnCount() >= (long)Mtimes.THRESHOLD && source2.getColumnCount() >= (long)Mtimes.THRESHOLD) {
            if (Mtimes.MTIMES_JBLAS != null && UJMPSettings.isUseJBlas()) {
                Mtimes.MTIMES_JBLAS.calc(source1, source2, target);
            } else if (UJMPSettings.isUseBlockMatrixMultiply()) {
                this.calcBlockMatrixMultiThreaded(source1, source2, target);
            } else if (source1 instanceof HasColumnMajorDoubleArray1D && source2 instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
                this.calcDoubleArrayMultiThreaded(((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D(), (int)source1.getRowCount(), (int)source1.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D(), (int)source2.getRowCount(), (int)source2.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
            } else if (source1 instanceof HasRowMajorDoubleArray2D && source2 instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
                this.calcDoubleArray2DMultiThreaded(((HasRowMajorDoubleArray2D)((Object)source1)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)source2)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
            } else {
                this.calcDenseDoubleMatrix2DMultiThreaded(source1, source2, target);
            }
        } else if (source1 instanceof HasColumnMajorDoubleArray1D && source2 instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.gemmDoubleArraySingleThreaded(((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D(), (int)source1.getRowCount(), (int)source1.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D(), (int)source2.getRowCount(), (int)source2.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source1 instanceof HasRowMajorDoubleArray2D && source2 instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calcDoubleArray2DSingleThreaded(((HasRowMajorDoubleArray2D)((Object)source1)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)source2)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            this.calcDenseDoubleMatrix2DSingleThreaded(source1, source2, target);
        }
    }

    private void calcBlockMatrixMultiThreaded(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
        BlockDenseDoubleMatrix2D a = null;
        BlockDenseDoubleMatrix2D b = null;
        BlockDenseDoubleMatrix2D c = null;
        a = source1 instanceof BlockDenseDoubleMatrix2D ? (BlockDenseDoubleMatrix2D)source1 : new BlockDenseDoubleMatrix2D(source1);
        b = source2 instanceof BlockDenseDoubleMatrix2D && a.getBlockStripeSize() == ((BlockDenseDoubleMatrix2D)source2).getBlockStripeSize() ? (BlockDenseDoubleMatrix2D)source2 : new BlockDenseDoubleMatrix2D(source2, a.getBlockStripeSize(), BlockMatrixLayout.BlockOrder.COLUMNMAJOR);
        int arows = (int)a.getRowCount();
        int bcols = (int)b.getColumnCount();
        c = target instanceof BlockDenseDoubleMatrix2D && a.getBlockStripeSize() == ((BlockDenseDoubleMatrix2D)target).getBlockStripeSize() ? (BlockDenseDoubleMatrix2D)target : new BlockDenseDoubleMatrix2D(arows, bcols, a.getBlockStripeSize(), BlockMatrixLayout.BlockOrder.ROWMAJOR);
        BlockMatrixLayout.BlockOrder prevA = a.setBlockOrder(BlockMatrixLayout.BlockOrder.ROWMAJOR);
        BlockMatrixLayout.BlockOrder prevB = b.setBlockOrder(BlockMatrixLayout.BlockOrder.COLUMNMAJOR);
        this.blockMultiplyMultiThreaded(a, b, c);
        if (c != target) {
            int j = bcols;
            while (--j != -1) {
                int i = arows;
                while (--i != -1) {
                    target.setDouble(c.getDouble(i, j), i, j);
                }
            }
        }
    }

    private final void gemmDoubleArraySingleThreaded(double[] A, int m1RowCount, int m1ColumnCount, double[] B, int m2RowCount, int m2ColumnCount, double[] C) {
        int j = 0;
        while (j < m2ColumnCount) {
            int jcolTimesM1RowCount = j * m1RowCount;
            int jcolTimesM1ColumnCount = j * m1ColumnCount;
            Arrays.fill(C, jcolTimesM1RowCount, jcolTimesM1RowCount + m1RowCount, 0.0);
            int lcol = 0;
            while (lcol < m1ColumnCount) {
                double temp = B[lcol + jcolTimesM1ColumnCount];
                if (temp != 0.0) {
                    int lcolTimesM1RowCount = lcol * m1RowCount;
                    int irow = 0;
                    while (irow < m1RowCount) {
                        int n = irow + jcolTimesM1RowCount;
                        C[n] = C[n] + A[irow + lcolTimesM1RowCount] * temp;
                        ++irow;
                    }
                }
                ++lcol;
            }
            ++j;
        }
    }

    private final void calcDoubleArrayMultiThreaded(final double[] A, final int m1RowCount, final int m1ColumnCount, final double[] B, int m2RowCount, int m2ColumnCount, final double[] C) {
        new PFor(0, m2ColumnCount - 1, new Object[0]){

            public void step(int i) {
                int jcolTimesM1RowCount = i * m1RowCount;
                int jcolTimesM1ColumnCount = i * m1ColumnCount;
                Arrays.fill(C, jcolTimesM1RowCount, jcolTimesM1RowCount + m1RowCount, 0.0);
                int lcol = 0;
                while (lcol < m1ColumnCount) {
                    double temp = B[lcol + jcolTimesM1ColumnCount];
                    if (temp != 0.0) {
                        int lcolTimesM1RowCount = lcol * m1RowCount;
                        int irow = 0;
                        while (irow < m1RowCount) {
                            int n = irow + jcolTimesM1RowCount;
                            C[n] = C[n] + A[irow + lcolTimesM1RowCount] * temp;
                            ++irow;
                        }
                    }
                    ++lcol;
                }
            }
        };
    }

    private final void calcDoubleArray2DSingleThreaded(double[][] m1, double[][] m2, double[][] ret) {
        int columnCount = m1[0].length;
        double[] columns = new double[columnCount];
        int c = m2[0].length;
        while (--c != -1) {
            int k = columnCount;
            while (--k != -1) {
                columns[k] = m2[k][c];
            }
            int r = m1.length;
            while (--r != -1) {
                double sum = 0.0;
                double[] row = m1[r];
                int k2 = columnCount;
                while (--k2 != -1) {
                    sum += row[k2] * columns[k2];
                }
                ret[r][c] = sum;
            }
        }
    }

    private final void calcDoubleArray2DMultiThreaded(final double[][] m1, final double[][] m2, final double[][] ret) {
        final int columnCount = m1[0].length;
        final double[] columns = new double[columnCount];
        new PFor(0, m2[0].length - 1, new Object[0]){

            public void step(int i) {
                int k = columnCount;
                while (--k != -1) {
                    columns[k] = m2[k][i];
                }
                int r = m1.length;
                while (--r != -1) {
                    double sum = 0.0;
                    double[] row = m1[r];
                    int k2 = columnCount;
                    while (--k2 != -1) {
                        sum += row[k2] * columns[k2];
                    }
                    ret[r][i] = sum;
                }
            }
        };
    }

    private final void calcDenseDoubleMatrix2DSingleThreaded(DenseDoubleMatrix2D A, DenseDoubleMatrix2D B, DenseDoubleMatrix2D C) {
        int m1RowCount = (int)A.getRowCount();
        int m1ColumnCount = (int)A.getColumnCount();
        int m2ColumnCount = (int)B.getColumnCount();
        int i = 0;
        while (i < m2ColumnCount) {
            int irow = 0;
            while (irow < m1RowCount) {
                C.setDouble(0.0, irow, i);
                ++irow;
            }
            int lcol = 0;
            while (lcol < m1ColumnCount) {
                double temp = B.getDouble(lcol, i);
                if (temp != 0.0) {
                    int irow2 = 0;
                    while (irow2 < m1RowCount) {
                        C.setDouble(C.getDouble(irow2, i) + A.getDouble(irow2, lcol) * temp, irow2, i);
                        ++irow2;
                    }
                }
                ++lcol;
            }
            ++i;
        }
    }

    private final void calcDenseDoubleMatrix2DMultiThreaded(final DenseDoubleMatrix2D A, final DenseDoubleMatrix2D B, final DenseDoubleMatrix2D C) {
        final int m1RowCount = (int)A.getRowCount();
        final int m1ColumnCount = (int)A.getColumnCount();
        int m2ColumnCount = (int)B.getColumnCount();
        new PFor(0, m2ColumnCount - 1, new Object[0]){

            public void step(int i) {
                int irow = 0;
                while (irow < m1RowCount) {
                    C.setDouble(0.0, irow, i);
                    ++irow;
                }
                int lcol = 0;
                while (lcol < m1ColumnCount) {
                    double temp = B.getDouble(lcol, i);
                    if (temp != 0.0) {
                        int irow2 = 0;
                        while (irow2 < m1RowCount) {
                            C.setDouble(C.getDouble(irow2, i) + A.getDouble(irow2, lcol) * temp, irow2, i);
                            ++irow2;
                        }
                    }
                    ++lcol;
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private BlockDenseDoubleMatrix2D blockMultiplyMultiThreaded(BlockDenseDoubleMatrix2D a, BlockDenseDoubleMatrix2D b, BlockDenseDoubleMatrix2D c) {
        block8: {
            al = a.getBlockLayout();
            bl = b.getBlockLayout();
            VerifyUtil.assertTrue(al.columns == bl.rows, "b.rows != this.columns");
            VerifyUtil.assertTrue(al.blockStripe == bl.blockStripe, "block sizes differ: %s != %s", new Object[]{al.blockStripe, bl.blockStripe});
            tasks = new LinkedList<BlockMultiply>();
            kMax = (int)b.getColumnCount();
            jMax = (int)a.getColumnCount();
            iMax = (int)a.getRowCount();
            bColSlice = Math.min(al.blockStripe, kMax);
            aColSlice = Math.min(al.blockStripe, jMax);
            aRowSlice = Math.min(al.blockStripe, iMax);
            blocksPerTask = true;
            blocksPerTaskDimJ = this.selectBlocksPerTaskDimJ(al.blockStripe, iMax, jMax, kMax);
            k = 0;
            while (k < kMax) {
                kStride = Math.min(1 * bColSlice, kMax - k);
                j = 0;
                while (j < jMax) {
                    jStride = Math.min(blocksPerTaskDimJ * aColSlice, jMax - j);
                    i = 0;
                    while (i < iMax) {
                        iStride = Math.min(1 * aRowSlice, iMax - i);
                        tasks.add(new BlockMultiply(a, b, c, i, i + iStride, j, j + jStride, k, k + kStride));
                        i += iStride;
                    }
                    j += jStride;
                }
                k += kStride;
            }
            try {
                for (Future<T> f : UJMPThreadPoolExecutor.getInstance().invokeAll(tasks)) {
                    f.get();
                }
            }
            catch (ExecutionException e) {
                sb = new StringBuilder("Execution exception - while awaiting completion of matrix multiplication [" + e.getMessage() + "]:");
                if (e.getCause() == null) break block8;
                var20_29 = e.getCause().getStackTrace();
                var19_27 = var20_29.length;
                var18_26 = 0;
                ** while (var18_26 < var19_27)
            }
lbl-1000:
            // 1 sources

            {
                stackTraceElement = var20_29[var18_26];
                sb.append(stackTraceElement).append("  *  ");
                ++var18_26;
                continue;
            }
        }
        throw new RuntimeException(sb.toString(), e.getCause());
        catch (InterruptedException e) {
            msg = "Interrupted - while awaiting completion of matrix multiplication.";
            throw new RuntimeException(String.valueOf(msg) + ": cause [" + e.getMessage() + "]", e);
        }
        return c;
    }

    private int selectBlocksPerTaskDimJ(int blockStripe, int iMax, int jMax, int kMax) {
        int adjust;
        int n = adjust = jMax % blockStripe > 0 ? 1 : 0;
        if (jMax < 5 * blockStripe || jMax <= iMax) {
            return jMax / blockStripe + adjust;
        }
        return Math.max(1, (jMax / blockStripe + adjust) / 2);
    }
}

