/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.shortmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasShortArray;
import org.ujmp.core.shortmatrix.stub.AbstractDenseShortMatrix2D;

public class DefaultDenseShortMatrix2D
extends AbstractDenseShortMatrix2D
implements HasShortArray {
    private static final long serialVersionUID = 3387495964006716189L;
    private short[] values = null;
    private long[] size = null;
    private int rows = 0;
    private int cols = 0;

    public DefaultDenseShortMatrix2D(Matrix m) throws MatrixException {
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseShortMatrix2D) {
            short[] v = ((DefaultDenseShortMatrix2D)m).values;
            this.values = new short[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new short[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setShort(m.getAsShort(c), c);
            }
        }
    }

    public DefaultDenseShortMatrix2D(long ... size) {
        this.rows = (int)size[0];
        this.cols = (int)size[1];
        this.size = new long[]{this.rows, this.cols};
        this.values = new short[this.rows * this.cols];
    }

    public DefaultDenseShortMatrix2D(short[] v, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    public long[] getSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getColumnCount() {
        return this.cols;
    }

    public short getShort(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setShort(short value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public short getShort(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setShort(short value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() throws MatrixException {
        short[] result = new short[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseShortMatrix2D m = new DefaultDenseShortMatrix2D(result, this.rows, this.cols);
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        short[] result = new short[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseShortMatrix2D(result, this.cols, this.rows);
    }

    public short[] getShortArray() {
        return this.values;
    }
}

