/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimesScalarDenseMatrix
implements TimesScalarCalculation<DenseMatrix, DenseMatrix> {
    TimesScalarDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, BigDecimal factor, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            TimesScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, factor, (DenseMatrix2D)target);
        } else {
            VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal value = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.times(value, factor);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(DenseMatrix source, double factor, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            TimesScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, factor, (DenseMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(factor, MathUtil.getDefaultMathContext()), target);
        }
    }
}

