/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.db.AbstractBioEntryDB;
import org.biojavax.bio.db.BioEntryDB;
import org.biojavax.bio.db.BioEntryDBLite;
import org.biojavax.bio.db.HashBioEntryDB;

public class BioSQLBioEntryDB
extends AbstractBioEntryDB {
    private Object session;
    private String name;
    private Method createQuery;
    private Method setParameter;
    private Method list;
    private Method delete;
    private Method saveOrUpdate;

    public BioSQLBioEntryDB(Object session) {
        this(null, session);
    }

    public BioSQLBioEntryDB(String name, Object session) {
        this.name = name;
        this.session = session;
        try {
            Class<?> hibernateSession = session.getClass();
            Class<?> realHibernateSession = Class.forName("org.hibernate.Session");
            if (!realHibernateSession.isAssignableFrom(hibernateSession)) {
                throw new IllegalArgumentException("Parameter must be a org.hibernate.Session object");
            }
            this.session = session;
            this.createQuery = hibernateSession.getMethod("createQuery", String.class);
            this.delete = hibernateSession.getMethod("delete", String.class, Object.class);
            this.saveOrUpdate = hibernateSession.getMethod("saveOrUpdate", String.class, Object.class);
            Class<?> hibernateQuery = Class.forName("org.hibernate.Query");
            this.setParameter = hibernateQuery.getMethod("setParameter", Integer.TYPE, Object.class);
            this.list = hibernateQuery.getMethod("list", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getHibernateSession() {
        return this.session;
    }

    public Set ids() {
        try {
            String queryText = "select distinct name from BioEntry";
            Object query = this.createQuery.invoke(this.session, queryText);
            List result = (List)this.list.invoke(query, null);
            return new HashSet(result);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load all names", e);
        }
    }

    public BioEntry getBioEntry(String id) throws IllegalIDException, BioException {
        try {
            String queryText = "from BioEntry where name = ?";
            Object query = this.createQuery.invoke(this.session, queryText);
            query = this.setParameter.invoke(query, new Integer(0), id);
            List result = (List)this.list.invoke(query, null);
            if (result.size() == 0) {
                throw new IllegalIDException("Id not found: " + id);
            }
            if (result.size() > 1) {
                throw new IllegalIDException("Multiple records found with that id - use getBioEntrys: " + id);
            }
            return (BioEntry)result.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load by id: " + id, e);
        }
    }

    public BioEntryDB getBioEntrys(Set ids) throws BioException, IllegalIDException {
        return this.getBioEntrys(ids, null);
    }

    public BioEntryDB getBioEntrys(Set ids, BioEntryDB db) throws BioException, IllegalIDException {
        if (db == null) {
            db = new HashBioEntryDB();
        }
        try {
            Iterator i = ids.iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                String queryText = "from BioEntry where name = ?";
                Object query = this.createQuery.invoke(this.session, queryText);
                List result = (List)this.list.invoke(query = this.setParameter.invoke(query, new Integer(0), id), null);
                if (result.size() == 0) {
                    throw new IllegalIDException("Id not found: " + id);
                }
                Iterator j = result.iterator();
                while (j.hasNext()) {
                    db.addBioEntry((BioEntry)j.next());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to load by ids: " + ids, e);
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBioEntry(String id) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(BioEntryDBLite.BIOENTRYS)) {
            this._removeBioEntry(id);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(BioEntryDBLite.BIOENTRYS);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, BioEntryDBLite.BIOENTRYS, null, id);
                changeSupport.firePreChangeEvent(ce);
                this._removeBioEntry(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void _removeBioEntry(String id) throws IllegalIDException, BioException, ChangeVetoException {
        try {
            BioEntry be = this.getBioEntry(id);
            this.delete.invoke(this.session, "BioEntry", be);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to delete by id: " + id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBioEntry(BioEntry seq) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(BioEntryDBLite.BIOENTRYS)) {
            this._addBioEntry(seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(BioEntryDBLite.BIOENTRYS);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, BioEntryDBLite.BIOENTRYS, null, seq);
                changeSupport.firePreChangeEvent(ce);
                this._addBioEntry(seq);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void _addBioEntry(BioEntry seq) throws IllegalIDException, BioException, ChangeVetoException {
        try {
            this.saveOrUpdate.invoke(this.session, "BioEntry", seq);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to save BioEntry with id: " + seq.getName(), e);
        }
    }
}

