/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.Location;

public class SequencesAsGFF {
    private FeatureFilter filter = FeatureFilter.all;
    private boolean recurse = false;
    private boolean shatter = false;
    private boolean generateSequenceHeader = true;

    public void setShatter(boolean b) {
        this.shatter = b;
    }

    public boolean getShatter() {
        return this.shatter;
    }

    public void setGenerateSequenceHeader(boolean b) {
        this.generateSequenceHeader = b;
    }

    public boolean getGenerateSequenceHeader() {
        return this.generateSequenceHeader;
    }

    public FeatureFilter getFeatureFilter() {
        return this.filter;
    }

    public void setFeatureFilter(FeatureFilter filter) {
        this.filter = filter;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    protected void doPreProcessSequence(Sequence seq, GFFDocumentHandler handler, String id) throws BioException {
        if (this.generateSequenceHeader) {
            handler.commentLine("#sequence-region " + id + " 1 " + seq.length());
        }
    }

    protected void doProcessSequence(Sequence seq, GFFDocumentHandler handler, String id) throws BioException {
        Iterator fi = seq.filter(this.getFeatureFilter(), this.getRecurse()).features();
        while (fi.hasNext()) {
            this.doProcessFeature((Feature)fi.next(), handler, id);
        }
    }

    protected void doProcessFeature(Feature feature, GFFDocumentHandler handler, String id) throws BioException {
        SimpleGFFRecord record = this.createGFFRecord(feature, id);
        if (this.shatter && !feature.getLocation().isContiguous()) {
            Iterator si = feature.getLocation().blockIterator();
            while (si.hasNext()) {
                Location shatterBloc = (Location)si.next();
                record.setStart(shatterBloc.getMin());
                record.setEnd(shatterBloc.getMax());
                handler.recordLine(record);
            }
        } else {
            handler.recordLine(record);
        }
    }

    protected SimpleGFFRecord createGFFRecord(Feature feature, String id) throws BioException {
        SimpleGFFRecord record = new SimpleGFFRecord();
        record.setSeqName(id);
        record.setSource(feature.getSource());
        record.setFeature(feature.getType());
        Location loc = feature.getLocation();
        record.setStart(loc.getMin());
        record.setEnd(loc.getMax());
        record.setScore(GFFTools.NO_SCORE);
        record.setStrand(StrandedFeature.UNKNOWN);
        if (feature instanceof StrandedFeature) {
            StrandedFeature sf = (StrandedFeature)feature;
            if (sf.getStrand() == StrandedFeature.POSITIVE) {
                record.setStrand(StrandedFeature.POSITIVE);
            } else if (sf.getStrand() == StrandedFeature.NEGATIVE) {
                record.setStrand(StrandedFeature.NEGATIVE);
            }
        }
        record.setFrame(GFFTools.NO_FRAME);
        Map fMap = feature.getAnnotation().asMap();
        HashMap fMap2 = new HashMap();
        Iterator ki = fMap.keySet().iterator();
        while (ki.hasNext()) {
            ArrayList<Object> valueList;
            Object key = ki.next();
            Object value = fMap.get(key);
            String keyS = key.toString();
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
            } else {
                valueList = new ArrayList<Object>();
                valueList.add(value);
            }
            for (int i = 0; i < valueList.size(); ++i) {
                Object o = valueList.get(i);
                valueList.set(i, o.toString());
            }
            fMap2.put(keyS, valueList);
        }
        record.setGroupAttributes(fMap2);
        record.setComment(null);
        return record;
    }

    public void processSequence(Sequence seq, GFFDocumentHandler handler) throws BioException {
        handler.startDocument(seq.getURN());
        this.doPreProcessSequence(seq, handler, seq.getName());
        this.doProcessSequence(seq, handler, seq.getName());
        handler.endDocument();
    }

    public void processDB(SequenceDB seqDB, GFFDocumentHandler handler) throws BioException {
        Sequence seq;
        String id;
        handler.startDocument("unknown:SequenceDB:" + seqDB.getName());
        Iterator i = seqDB.ids().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            seq = seqDB.getSequence(id);
            this.doPreProcessSequence(seq, handler, id);
        }
        i = seqDB.ids().iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            seq = seqDB.getSequence(id);
            this.doProcessSequence(seq, handler, id);
        }
        handler.endDocument();
    }
}

