/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;

public class StackedLogoPainter
implements LogoPainter {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public void paintLogo(LogoContext lCtxt) {
        Distribution dis = lCtxt.getDistribution();
        SymbolTokenization toke = null;
        try {
            toke = dis.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
        Rectangle bounds = lCtxt.getBounds();
        double height = bounds.getHeight();
        TreeSet<ResVal> info = new TreeSet<ResVal>(new ResValComparator(toke));
        try {
            Iterator i = ((FiniteAlphabet)dis.getAlphabet()).iterator();
            while (i.hasNext()) {
                AtomicSymbol s = (AtomicSymbol)i.next();
                info.add(new ResVal(s, dis.getWeight(s) * height));
            }
        }
        catch (IllegalSymbolException ire) {
            throw new BioError("Symbol dissapeared from dis alphabet", ire);
        }
        Rectangle r = new Rectangle();
        r.x = bounds.x;
        r.y = 0;
        r.width = bounds.width;
        Iterator i = info.iterator();
        while (i.hasNext()) {
            ResVal rv = (ResVal)i.next();
            r.height = (int)rv.getValue();
            lCtxt.getBlockPainter().paintBlock(lCtxt, r, rv.getToken());
            r.y = (int)((double)r.y - rv.getValue());
        }
    }

    private static class ResValComparator
    implements Comparator {
        private SymbolTokenization toke;

        public ResValComparator(SymbolTokenization toke) {
            this.toke = toke;
        }

        public final int compare(Object o1, Object o2) {
            ResVal rv1 = (ResVal)o1;
            ResVal rv2 = (ResVal)o2;
            double diff = rv1.getValue() - rv2.getValue();
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            try {
                return this.toke.tokenizeSymbol(rv1.getToken()).compareTo(this.toke.tokenizeSymbol(rv2.getToken()));
            }
            catch (IllegalSymbolException ex) {
                throw new BioError("Couldn't tokenize symbols", ex);
            }
        }
    }

    private static class ResVal {
        private AtomicSymbol symbol;
        private double value;

        public final AtomicSymbol getToken() {
            return this.symbol;
        }

        public final double getValue() {
            return this.value;
        }

        public ResVal(AtomicSymbol sym, double val) {
            this.symbol = sym;
            this.value = val;
        }
    }
}

