/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public class svm_test {
    public static void main(String[] argv) throws IOException {
        svm_test t = new svm_test();
        t.test();
    }

    public void test() {
        int i;
        ArrayList<Double> labels = new ArrayList<Double>();
        labels.add(0.0);
        labels.add(1.0);
        labels.add(1.0);
        labels.add(0.0);
        double[][] samples = new double[4][2];
        samples[0][0] = 0.0;
        samples[0][1] = 0.0;
        samples[1][0] = 0.0;
        samples[1][1] = 1.0;
        samples[2][0] = 1.0;
        samples[2][1] = 0.0;
        samples[3][0] = 1.0;
        samples[3][1] = 1.0;
        int m = 4;
        int n = 2;
        Vector<Double> vy = new Vector<Double>();
        Vector<svm_node[]> vx = new Vector<svm_node[]>();
        int max_index = 0;
        for (int k = 0; k < m; ++k) {
            svm_node[] x = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                x[j] = new svm_node();
                x[j].index = j + 1;
                x[j].value = samples[k][j];
                System.out.print(x[j].index + ":" + x[j].value + " ");
            }
            System.out.println();
            if (n > 0) {
                max_index = Math.max(max_index, x[n - 1].index);
            }
            vx.addElement(x);
            vy.addElement((Double)labels.get(k));
        }
        svm_problem prob = new svm_problem();
        prob.l = vy.size();
        prob.x = new svm_node[prob.l][];
        for (i = 0; i < prob.l; ++i) {
            prob.x[i] = (svm_node[])vx.elementAt(i);
        }
        prob.y = new double[prob.l];
        for (i = 0; i < prob.l; ++i) {
            prob.y[i] = (Double)vy.elementAt(i);
        }
        svm_parameter param = new svm_parameter();
        param.setDefaults();
        param.kernel_type = 2;
        param.C = 10.0;
        System.out.println(param.toString());
        if (param.gamma == 0.0 && max_index > 0) {
            param.gamma = 1.0 / (double)max_index;
        }
        svm_model model = svm.svm_train(prob, param);
        String model_file_name = "/Users/shirleyhui/Desktop/svm_test-2.model";
        try {
            svm.svm_save_model(model_file_name, model);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        svm_node[] x1 = new svm_node[n];
        x1[0] = new svm_node();
        x1[0].index = 1;
        x1[0].value = 1.0;
        x1[1] = new svm_node();
        x1[1].index = 2;
        x1[1].value = 3.0;
        double v = svm.svm_predict(model, x1);
        System.out.println(v);
        System.out.println("Finished...");
    }
}

