/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.correlationlearn;

import mt.MatrixEntry;
import org.baderlab.brain.correlationlearn.FeatureUtils;
import org.baderlab.brain.correlationlearn.ResiduePositionPair;
import smt.FlexCompRowMatrix;

public class ResidueResidueCorrelationMatrix {
    protected FlexCompRowMatrix correlationMatrix = null;
    protected boolean domainPositionsAsRows = false;
    protected int numRows = 0;
    protected int numColumns = 0;

    public ResidueResidueCorrelationMatrix(int numDomainPositionsPerFeature, int numPeptidePositionsPerFeature, int totalDomainSequenceLength, int totalPeptideSequenceLength) {
        int maxDomainIndex = FeatureUtils.getMaxIndex(numDomainPositionsPerFeature, totalDomainSequenceLength);
        int maxPeptideIndex = FeatureUtils.getMaxIndex(numPeptidePositionsPerFeature, totalPeptideSequenceLength);
        if (maxDomainIndex > maxPeptideIndex) {
            this.domainPositionsAsRows = false;
            this.numRows = maxPeptideIndex;
            this.numColumns = maxDomainIndex;
        } else {
            this.domainPositionsAsRows = true;
            this.numRows = maxDomainIndex;
            this.numColumns = maxPeptideIndex;
        }
        this.correlationMatrix = new FlexCompRowMatrix(this.numRows, this.numColumns);
    }

    public void addCorrelationCount(ResiduePositionPair[] domainFeature, ResiduePositionPair[] peptideFeature) {
        int domainIndex = FeatureUtils.getFeatureIndex(domainFeature);
        int peptideIndex = FeatureUtils.getFeatureIndex(peptideFeature);
        if (this.domainPositionsAsRows) {
            this.correlationMatrix.add(domainIndex, peptideIndex, 1.0);
        } else {
            this.correlationMatrix.add(peptideIndex, domainIndex, 1.0);
        }
    }

    protected ResiduePositionPair[] getDomainFeatureFromSparseMatrixEntry(MatrixEntry matrixEntry, ResiduePositionPair[] preAllocatedDomainFeature, int totalDomainSequenceLength) {
        ResiduePositionPair[] domainFeature = null;
        if (this.correlationMatrix == null) {
            return domainFeature;
        }
        int columnIndex = matrixEntry.column();
        int rowIndex = matrixEntry.row();
        domainFeature = this.domainPositionsAsRows ? FeatureUtils.indexToFeature(rowIndex, preAllocatedDomainFeature, totalDomainSequenceLength) : FeatureUtils.indexToFeature(columnIndex, preAllocatedDomainFeature, totalDomainSequenceLength);
        return domainFeature;
    }

    protected ResiduePositionPair[] getPeptideFeatureFromSparseMatrixEntry(MatrixEntry matrixEntry, ResiduePositionPair[] preAllocatedPeptideFeature, int totalPeptideSequenceLength) {
        ResiduePositionPair[] peptideFeature = null;
        if (this.correlationMatrix == null) {
            return peptideFeature;
        }
        int columnIndex = matrixEntry.column();
        int rowIndex = matrixEntry.row();
        peptideFeature = this.domainPositionsAsRows ? FeatureUtils.indexToFeature(columnIndex, preAllocatedPeptideFeature, totalPeptideSequenceLength) : FeatureUtils.indexToFeature(rowIndex, preAllocatedPeptideFeature, totalPeptideSequenceLength);
        return peptideFeature;
    }

    public boolean domainPositionsAsRows() {
        return this.domainPositionsAsRows;
    }

    public FlexCompRowMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }
}

