/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.List;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;

public class AlignmentMatrix
extends DistanceMatrix {
    private int[] alignmentPositionMatrix = null;
    private int matrixDim = 0;

    public AlignmentMatrix(int matrixDim) {
        super(matrixDim);
        this.matrixDim = matrixDim;
        this.alignmentPositionMatrix = new int[matrixDim * matrixDim];
    }

    public void setAlignmentValue(int i, int j, int value) {
        this.alignmentPositionMatrix[i * this.matrixDim + j] = value;
    }

    public int getAlignmentValue(int i, int j) {
        if (i == j) {
            return 0;
        }
        return this.alignmentPositionMatrix[i * this.matrixDim + j];
    }

    public void calcAlignment(List proteinProfileList, String grouping) {
        for (int i = 0; i < proteinProfileList.size(); ++i) {
            ProteinProfile profile1 = (ProteinProfile)proteinProfileList.get(i);
            for (int j = 0; j < proteinProfileList.size(); ++j) {
                ProteinProfile profile2 = (ProteinProfile)proteinProfileList.get(j);
                this.setAlignmentValue(i, j, ProteinProfileDistance.calculateOptimalAlignedPosition(profile1, profile2, grouping));
            }
        }
    }

    public AlignmentMatrix copyAlignment() {
        AlignmentMatrix dm = new AlignmentMatrix(this.getMatrixDimension());
        System.arraycopy(this.alignmentPositionMatrix, 0, dm.alignmentPositionMatrix, 0, this.alignmentPositionMatrix.length);
        dm.setLabels(this.getLabels());
        return dm;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (i = 0; i < this.getLabels().size(); ++i) {
            sb.append("\t" + (String)this.getLabels().get(i));
        }
        sb.append(lineSep);
        for (i = 0; i < this.getMatrixDimension(); ++i) {
            sb.append(this.getLabels().get(i) + "\t");
            for (int j = 0; j < this.getMatrixDimension(); ++j) {
                sb.append(this.getValue(i, j) + "[" + this.getAlignmentValue(i, j) + "]");
                sb.append("\t");
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }
}

