/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;

public class StructureTools {
    public static final String caAtomName = "CA";
    public static final String[] backboneAtomNames = new String[]{"N", "CA", "C", "O", "CB"};

    public static int getNrAtoms(Structure s) {
        int nrAtoms = 0;
        GroupIterator iter = new GroupIterator(s);
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            nrAtoms += g.size();
        }
        return nrAtoms;
    }

    public static int getNrGroups(Structure s) {
        int nrGroups = 0;
        List chains = s.getChains(0);
        Iterator iter = chains.iterator();
        while (iter.hasNext()) {
            Chain c = (Chain)iter.next();
            nrGroups += c.getLength();
        }
        return nrGroups;
    }

    public static Atom[] getAtomArray(Structure s, String[] atomNames) {
        GroupIterator iter = new GroupIterator(s);
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
            boolean thisGroupAllAtoms = true;
            for (int i = 0; i < atomNames.length; ++i) {
                String atomName = atomNames[i];
                try {
                    Atom a = g.getAtom(atomName);
                    thisGroupAtoms.add(a);
                    continue;
                }
                catch (StructureException e) {
                    thisGroupAllAtoms = false;
                }
            }
            if (!thisGroupAllAtoms) continue;
            Iterator aIter = thisGroupAtoms.iterator();
            while (aIter.hasNext()) {
                Atom a = (Atom)aIter.next();
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static Atom[] getAtomCAArray(Structure s) {
        String[] atomNames = new String[]{caAtomName};
        return StructureTools.getAtomArray(s, atomNames);
    }

    public static Atom[] getBackboneAtomArray(Structure s) {
        String[] atomNames = backboneAtomNames;
        return StructureTools.getAtomArray(s, atomNames);
    }
}

