/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.AbstractStringDistanceFunction;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class EditDistance
extends AbstractStringDistanceFunction {
    public EditDistance() {
    }

    public EditDistance(Instances instances) {
        super(instances);
    }

    double stringDistance(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        double[][] dArray = new double[n2 + 1][n3 + 1];
        for (n = 0; n <= n2; ++n) {
            dArray[n][0] = n;
        }
        for (n = 1; n <= n3; ++n) {
            dArray[0][n] = n;
        }
        for (n = 1; n <= n2; ++n) {
            for (int i = 1; i <= n3; ++i) {
                dArray[n][i] = string.charAt(n - 1) == string2.charAt(i - 1) ? dArray[n - 1][i - 1] : 1.0 + Math.min(dArray[n - 1][i], Math.min(dArray[n][i - 1], dArray[n - 1][i - 1]));
            }
        }
        return dArray[n2][n3];
    }

    public String globalInfo() {
        return "Implementing Levenshtein distance function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see: http://en.wikipedia.org/wiki/Levenshtein_distance\n\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

