/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.Rule;
import weka.classifiers.rules.RuleStats;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.ClassOrder;

public class JRip
extends Classifier
implements AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6589312996832147161L;
    private static double MAX_DL_SURPLUS = 64.0;
    private Attribute m_Class;
    private FastVector m_Ruleset;
    private FastVector m_Distributions;
    private int m_Optimizations = 2;
    private Random m_Random = null;
    private double m_Total = 0.0;
    private long m_Seed = 1L;
    private int m_Folds = 3;
    private double m_MinNo = 2.0;
    private boolean m_Debug = false;
    private boolean m_CheckErr = true;
    private boolean m_UsePruning = true;
    private Filter m_Filter = null;
    private FastVector m_RulesetStats;

    public String globalInfo() {
        return "This class implements a propositional rule learner, Repeated Incremental Pruning to Produce Error Reduction (RIPPER), which was proposed by William W. Cohen as an optimized version of IREP. \n\nThe algorithm is briefly described as follows: \n\nInitialize RS = {}, and for each class from the less prevalent one to the more frequent one, DO: \n\n1. Building stage:\nRepeat 1.1 and 1.2 until the descrition length (DL) of the ruleset and examples is 64 bits greater than the smallest DL met so far, or there are no positive examples, or the error rate >= 50%. \n\n1.1. Grow phase:\nGrow one rule by greedily adding antecedents (or conditions) to the rule until the rule is perfect (i.e. 100% accurate).  The procedure tries every possible value of each attribute and selects the condition with highest information gain: p(log(p/t)-log(P/T)).\n\n1.2. Prune phase:\nIncrementally prune each rule and allow the pruning of any final sequences of the antecedents;The pruning metric is (p-n)/(p+n) -- but it's actually 2p/(p+n) -1, so in this implementation we simply use p/(p+n) (actually (p+1)/(p+n+2), thus if p+n is 0, it's 0.5).\n\n2. Optimization stage:\n after generating the initial ruleset {Ri}, generate and prune two variants of each rule Ri from randomized data using procedure 1.1 and 1.2. But one variant is generated from an empty rule while the other is generated by greedily adding antecedents to the original rule. Moreover, the pruning metric used here is (TP+TN)/(P+N).Then the smallest possible DL for each variant and the original rule is computed.  The variant with the minimal DL is selected as the final representative of Ri in the ruleset.After all the rules in {Ri} have been examined and if there are still residual positives, more rules are generated based on the residual positives using Building Stage again. \n3. Delete the rules from the ruleset that would increase the DL of the whole ruleset if it were in it. and add resultant ruleset to RS. \nENDDO\n\nNote that there seem to be 2 bugs in the original ripper program that would affect the ruleset size and accuracy slightly.  This implementation avoids these bugs and thus is a little bit different from Cohen's original implementation. Even after fixing the bugs, since the order of classes with the same frequency is not defined in ripper, there still seems to be some trivial difference between this implementation and the original ripper, especially for audiology data in UCI repository, where there are lots of classes of few instances.\n\nDetails please see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "PS.  We have compared this implementation with the original ripper " + "implementation in aspects of accuracy, ruleset size and running time " + "on both artificial data \"ab+bcd+defg\" and UCI datasets.  In all these " + "aspects it seems to be quite comparable to the original ripper " + "implementation.  However, we didn't consider memory consumption " + "optimization in this implementation.\n\n";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "William W. Cohen");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Fast Effective Rule Induction");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Twelfth International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "115-123");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        vector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        vector.addElement(new Option("\tSet the number of runs of\n\toptimizations. (Default: 2)", "O", 1, "-O <number of runs>"));
        vector.addElement(new Option("\tSet whether turn on the\n\tdebug mode (Default: false)", "D", 0, "-D"));
        vector.addElement(new Option("\tThe seed of randomization\n\t(Default: 1)", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tWhether NOT check the error rate>=0.5\n\tin stopping criteria \t(default: check)", "E", 0, "-E"));
        vector.addElement(new Option("\tWhether NOT use pruning\n\t(default: use pruning)", "P", 0, "-P"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        this.m_Folds = string.length() != 0 ? Integer.parseInt(string) : 3;
        String string2 = Utils.getOption('N', stringArray);
        this.m_MinNo = string2.length() != 0 ? Double.parseDouble(string2) : 2.0;
        String string3 = Utils.getOption('S', stringArray);
        this.m_Seed = string3.length() != 0 ? Long.parseLong(string3) : 1L;
        String string4 = Utils.getOption('O', stringArray);
        this.m_Optimizations = string4.length() != 0 ? Integer.parseInt(string4) : 2;
        this.m_Debug = Utils.getFlag('D', stringArray);
        this.m_CheckErr = !Utils.getFlag('E', stringArray);
        this.m_UsePruning = !Utils.getFlag('P', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.m_Folds;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_MinNo;
        stringArray[n++] = "-O";
        stringArray[n++] = "" + this.m_Optimizations;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Seed;
        if (this.m_Debug) {
            stringArray[n++] = "-D";
        }
        if (!this.m_CheckErr) {
            stringArray[n++] = "-E";
        }
        if (!this.m_UsePruning) {
            stringArray[n++] = "-P";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(string + " not supported (RIPPER)");
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int n) {
        this.m_Folds = n;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double d) {
        this.m_MinNo = d;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long l) {
        this.m_Seed = l;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return "The number of optimization runs.";
    }

    public void setOptimizations(int n) {
        this.m_Optimizations = n;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return "Whether check for error rate >= 1/2 is included in stopping criterion.";
    }

    public void setCheckErrorRate(boolean bl) {
        this.m_CheckErr = bl;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String usePruningTipText() {
        return "Whether pruning is performed.";
    }

    public void setUsePruning(boolean bl) {
        this.m_UsePruning = bl;
    }

    public boolean getUsePruning() {
        return this.m_UsePruning;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int n) {
        return (RuleStats)this.m_RulesetStats.elementAt(n);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(this.m_Folds);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Random = instances.getRandomNumberGenerator(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println("Number of all possible conditions = " + this.m_Total);
        }
        Instances instances2 = null;
        this.m_Filter = new ClassOrder();
        ((ClassOrder)this.m_Filter).setSeed(this.m_Random.nextInt());
        ((ClassOrder)this.m_Filter).setClassOrder(0);
        this.m_Filter.setInputFormat(instances);
        instances2 = Filter.useFilter(instances, this.m_Filter);
        if (instances2 == null) {
            throw new Exception(" Unable to randomize the class orders.");
        }
        this.m_Class = instances2.classAttribute();
        this.m_Ruleset = new FastVector();
        this.m_RulesetStats = new FastVector();
        this.m_Distributions = new FastVector();
        double[] dArray = ((ClassOrder)this.m_Filter).getClassCounts();
        if (this.m_Debug) {
            System.err.println("Sorted classes:");
            for (n2 = 0; n2 < this.m_Class.numValues(); ++n2) {
                System.err.println(n2 + ": " + this.m_Class.value(n2) + " has " + dArray[n2] + " instances.");
            }
        }
        for (n2 = 0; n2 < instances2.numClasses() - 1; ++n2) {
            double d = n2;
            if (this.m_Debug) {
                int n3 = (int)d;
                System.err.println("\n\nClass " + this.m_Class.value(n3) + "(" + n3 + "): " + dArray[n2] + "instances\n" + "=====================================\n");
            }
            if (Utils.eq(dArray[n2], 0.0)) continue;
            double d2 = 0.0;
            for (int i = n2; i < dArray.length; ++i) {
                d2 += dArray[i];
            }
            double d3 = dArray[n2] / d2;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance = instances2.instance(i);
                d5 += instance.weight();
                if ((int)instance.classValue() != n2) continue;
                d4 += instance.weight();
            }
            if (!(d4 > 0.0)) continue;
            double d6 = RuleStats.dataDL(d3, 0.0, d5, 0.0, d4);
            if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                throw new Exception("Should never happen: defDL NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("The default DL = " + d6);
            }
            instances2 = this.rulesetForOneClass(d3, instances2, d, d6);
        }
        RipperRule ripperRule = new RipperRule();
        ripperRule.setConsequent(instances2.numClasses() - 1);
        this.m_Ruleset.addElement(ripperRule);
        RuleStats ruleStats = new RuleStats();
        ruleStats.setData(instances2);
        ruleStats.setNumAllConds(this.m_Total);
        ruleStats.addAndUpdate(ripperRule);
        this.m_RulesetStats.addElement(ruleStats);
        for (n = 0; n < this.m_RulesetStats.size(); ++n) {
            RuleStats ruleStats2 = (RuleStats)this.m_RulesetStats.elementAt(n);
            for (int i = 0; i < ruleStats2.getRulesetSize(); ++i) {
                double[] dArray2 = ruleStats2.getDistributions(i);
                Utils.normalize(dArray2);
                if (dArray2 == null) continue;
                this.m_Distributions.addElement(((ClassOrder)this.m_Filter).distributionsByOriginalIndex(dArray2));
            }
        }
        for (n = 0; n < this.m_RulesetStats.size(); ++n) {
            ((RuleStats)this.m_RulesetStats.elementAt(n)).cleanUp();
        }
    }

    public double[] distributionForInstance(Instance instance) {
        try {
            for (int i = 0; i < this.m_Ruleset.size(); ++i) {
                RipperRule ripperRule = (RipperRule)this.m_Ruleset.elementAt(i);
                if (!ripperRule.covers(instance)) continue;
                return (double[])this.m_Distributions.elementAt(i);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.err.println("Should never happen!");
        return new double[instance.classAttribute().numValues()];
    }

    protected Instances rulesetForOneClass(double d, Instances instances, double d2, double d3) throws Exception {
        double[] dArray;
        int n;
        RevisionHandler revisionHandler;
        Instances instances2;
        Instances instances3;
        boolean bl;
        Instances instances4 = instances;
        boolean bl2 = false;
        FastVector fastVector = new FastVector();
        double d4 = d3;
        double d5 = d3;
        RevisionHandler revisionHandler2 = null;
        boolean bl3 = bl = true;
        if (this.m_Debug) {
            System.err.println("\n*** Building stage ***");
        }
        while (!bl2 && bl3) {
            if (this.m_UsePruning) {
                instances4 = RuleStats.stratify(instances4, this.m_Folds, this.m_Random);
                Instances[] instancesArray = RuleStats.partition(instances4, this.m_Folds);
                instances3 = instancesArray[0];
                instances2 = instancesArray[1];
                revisionHandler = new RipperRule();
                ((RipperRule)revisionHandler).setConsequent(d2);
                if (this.m_Debug) {
                    System.err.println("\nGrowing a rule ...");
                }
                ((RipperRule)revisionHandler).grow(instances3);
                if (this.m_Debug) {
                    System.err.println("One rule found before pruning:" + ((RipperRule)revisionHandler).toString(this.m_Class));
                }
                if (this.m_Debug) {
                    System.err.println("\nPruning the rule ...");
                }
                ((RipperRule)revisionHandler).prune(instances2, false);
                if (this.m_Debug) {
                    System.err.println("One rule found after pruning:" + ((RipperRule)revisionHandler).toString(this.m_Class));
                }
            } else {
                revisionHandler = new RipperRule();
                ((RipperRule)revisionHandler).setConsequent(d2);
                if (this.m_Debug) {
                    System.err.println("\nNo pruning: growing a rule ...");
                }
                ((RipperRule)revisionHandler).grow(instances4);
                if (this.m_Debug) {
                    System.err.println("No pruning: one rule found:\n" + ((RipperRule)revisionHandler).toString(this.m_Class));
                }
            }
            if (revisionHandler2 == null) {
                revisionHandler2 = new RuleStats();
                ((RuleStats)revisionHandler2).setNumAllConds(this.m_Total);
                ((RuleStats)revisionHandler2).setData(instances4);
            }
            ((RuleStats)revisionHandler2).addAndUpdate((Rule)revisionHandler);
            n = ((RuleStats)revisionHandler2).getRuleset().size() - 1;
            if (Double.isNaN(d4 += ((RuleStats)revisionHandler2).relativeDL(n, d, this.m_CheckErr)) || Double.isInfinite(d4)) {
                throw new Exception("Should never happen: dl in building stage NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("Before optimization(" + n + "): the dl = " + d4 + " | best: " + d5);
            }
            if (d4 < d5) {
                d5 = d4;
            }
            dArray = ((RuleStats)revisionHandler2).getSimpleStats(n);
            if (this.m_Debug) {
                System.err.println("The rule covers: " + dArray[0] + " | pos = " + dArray[2] + " | neg = " + dArray[4] + "\nThe rule doesn't cover: " + dArray[1] + " | pos = " + dArray[5]);
            }
            if (!(bl2 = this.checkStop(dArray, d5, d4))) {
                fastVector.addElement(revisionHandler);
                instances4 = ((RuleStats)revisionHandler2).getFiltered(n)[1];
                bl3 = Utils.gr(dArray[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println("One rule added: has positive? " + bl3);
                continue;
            }
            if (this.m_Debug) {
                System.err.println("Quit rule");
            }
            ((RuleStats)revisionHandler2).removeLast();
        }
        revisionHandler = null;
        if (this.m_UsePruning) {
            for (n = 0; n < this.m_Optimizations; ++n) {
                if (this.m_Debug) {
                    System.err.println("\n*** Optimization: run #" + n + " ***");
                }
                instances4 = instances;
                revisionHandler = new RuleStats();
                ((RuleStats)revisionHandler).setData(instances4);
                ((RuleStats)revisionHandler).setNumAllConds(this.m_Total);
                int n2 = 0;
                bl2 = false;
                boolean bl4 = false;
                bl3 = bl;
                d4 = d5 = d3;
                while (!bl2 && bl3) {
                    RipperRule ripperRule;
                    RipperRule ripperRule2;
                    bl4 = n2 >= fastVector.size();
                    instances4 = RuleStats.stratify(instances4, this.m_Folds, this.m_Random);
                    Instances[] instancesArray = RuleStats.partition(instances4, this.m_Folds);
                    instances3 = instancesArray[0];
                    instances2 = instancesArray[1];
                    if (this.m_Debug) {
                        System.err.println("\nRule #" + n2 + "| isResidual?" + bl4 + "| data size: " + instances4.sumOfWeights());
                    }
                    if (bl4) {
                        ripperRule2 = new RipperRule();
                        ripperRule2.setConsequent(d2);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning a new rule ...");
                        }
                        ripperRule2.grow(instances3);
                        ripperRule2.prune(instances2, false);
                        ripperRule = ripperRule2;
                        if (this.m_Debug) {
                            System.err.println("\nNew rule found: " + ripperRule2.toString(this.m_Class));
                        }
                    } else {
                        Copyable copyable;
                        ripperRule2 = (RipperRule)fastVector.elementAt(n2);
                        boolean bl5 = false;
                        for (int i = 0; i < instances4.numInstances(); ++i) {
                            if (!ripperRule2.covers(instances4.instance(i))) continue;
                            bl5 = true;
                            break;
                        }
                        if (!bl5) {
                            ((RuleStats)revisionHandler).addAndUpdate(ripperRule2);
                            ++n2;
                            continue;
                        }
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Replace ...");
                        }
                        RipperRule ripperRule3 = new RipperRule();
                        ripperRule3.setConsequent(d2);
                        ripperRule3.grow(instances3);
                        instances2 = RuleStats.rmCoveredBySuccessives(instances2, fastVector, n2);
                        ripperRule3.prune(instances2, true);
                        if (this.m_Debug) {
                            System.err.println("\nGrowing and pruning Revision ...");
                        }
                        RipperRule ripperRule4 = (RipperRule)ripperRule2.copy();
                        Instances instances5 = new Instances(instances3, 0);
                        for (int i = 0; i < instances3.numInstances(); ++i) {
                            copyable = instances3.instance(i);
                            if (!ripperRule4.covers((Instance)copyable)) continue;
                            instances5.add((Instance)copyable);
                        }
                        ripperRule4.grow(instances5);
                        ripperRule4.prune(instances2, true);
                        double[][] dArray2 = new double[n2][6];
                        for (int i = 0; i < n2; ++i) {
                            dArray2[i] = ((RuleStats)revisionHandler).getSimpleStats(i);
                        }
                        copyable = (FastVector)fastVector.copyElements();
                        ((FastVector)copyable).setElementAt(ripperRule3, n2);
                        RuleStats ruleStats = new RuleStats(instances, (FastVector)copyable);
                        ruleStats.setNumAllConds(this.m_Total);
                        ruleStats.countData(n2, instances4, dArray2);
                        dArray = ruleStats.getSimpleStats(n2);
                        if (this.m_Debug) {
                            System.err.println("Replace rule covers: " + dArray[0] + " | pos = " + dArray[2] + " | neg = " + dArray[4] + "\nThe rule doesn't cover: " + dArray[1] + " | pos = " + dArray[5]);
                        }
                        double d6 = ruleStats.relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("\nReplace: " + ripperRule3.toString(this.m_Class) + " |dl = " + d6);
                        }
                        if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                            throw new Exception("Should never happen: repDLin optmz. stage NaN or infinite!");
                        }
                        ((FastVector)copyable).setElementAt(ripperRule4, n2);
                        RuleStats ruleStats2 = new RuleStats(instances, (FastVector)copyable);
                        ruleStats2.setNumAllConds(this.m_Total);
                        ruleStats2.countData(n2, instances4, dArray2);
                        double d7 = ruleStats2.relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("Revision: " + ripperRule4.toString(this.m_Class) + " |dl = " + d7);
                        }
                        if (Double.isNaN(d7) || Double.isInfinite(d7)) {
                            throw new Exception("Should never happen: revDLin optmz. stage NaN or infinite!");
                        }
                        revisionHandler2 = new RuleStats(instances, fastVector);
                        ((RuleStats)revisionHandler2).setNumAllConds(this.m_Total);
                        ((RuleStats)revisionHandler2).countData(n2, instances4, dArray2);
                        double d8 = ((RuleStats)revisionHandler2).relativeDL(n2, d, this.m_CheckErr);
                        if (Double.isNaN(d8) || Double.isInfinite(d8)) {
                            throw new Exception("Should never happen: oldDLin optmz. stage NaN or infinite!");
                        }
                        if (this.m_Debug) {
                            System.err.println("Old rule: " + ripperRule2.toString(this.m_Class) + " |dl = " + d8);
                        }
                        if (this.m_Debug) {
                            System.err.println("\nrepDL: " + d6 + "\nrevDL: " + d7 + "\noldDL: " + d8);
                        }
                        ripperRule = d8 <= d7 && d8 <= d6 ? ripperRule2 : (d7 <= d6 ? ripperRule4 : ripperRule3);
                    }
                    ((RuleStats)revisionHandler).addAndUpdate(ripperRule);
                    dArray = ((RuleStats)revisionHandler).getSimpleStats(n2);
                    if (bl4) {
                        d4 += ((RuleStats)revisionHandler).relativeDL(n2, d, this.m_CheckErr);
                        if (this.m_Debug) {
                            System.err.println("After optimization: the dl=" + d4 + " | best: " + d5);
                        }
                        if (d4 < d5) {
                            d5 = d4;
                        }
                        if (!(bl2 = this.checkStop(dArray, d5, d4))) {
                            fastVector.addElement(ripperRule);
                        } else {
                            ((RuleStats)revisionHandler).removeLast();
                            --n2;
                        }
                    } else {
                        fastVector.setElementAt(ripperRule, n2);
                    }
                    if (this.m_Debug) {
                        System.err.println("The rule covers: " + dArray[0] + " | pos = " + dArray[2] + " | neg = " + dArray[4] + "\nThe rule doesn't cover: " + dArray[1] + " | pos = " + dArray[5]);
                        System.err.println("\nRuleset so far: ");
                        for (int i = 0; i < fastVector.size(); ++i) {
                            System.err.println(i + ": " + ((RipperRule)fastVector.elementAt(i)).toString(this.m_Class));
                        }
                        System.err.println();
                    }
                    if (((RuleStats)revisionHandler).getRulesetSize() > 0) {
                        instances4 = ((RuleStats)revisionHandler).getFiltered(n2)[1];
                    }
                    bl3 = Utils.gr(dArray[5], 0.0);
                    ++n2;
                }
                if (fastVector.size() > n2 + 1) {
                    for (int i = n2 + 1; i < fastVector.size(); ++i) {
                        ((RuleStats)revisionHandler).addAndUpdate((Rule)fastVector.elementAt(i));
                    }
                }
                if (this.m_Debug) {
                    System.err.println("\nDeleting rules to decrease DL of the whole ruleset ...");
                }
                ((RuleStats)revisionHandler).reduceDL(d, this.m_CheckErr);
                if (this.m_Debug) {
                    int n3 = fastVector.size() - ((RuleStats)revisionHandler).getRulesetSize();
                    System.err.println(n3 + " rules are deleted" + " after DL reduction procedure");
                }
                fastVector = ((RuleStats)revisionHandler).getRuleset();
                revisionHandler2 = revisionHandler;
            }
        }
        if (this.m_Debug) {
            System.err.println("\nFinal ruleset: ");
            for (n = 0; n < fastVector.size(); ++n) {
                System.err.println(n + ": " + ((RipperRule)fastVector.elementAt(n)).toString(this.m_Class));
            }
            System.err.println();
        }
        this.m_Ruleset.appendElements(fastVector);
        this.m_RulesetStats.addElement(revisionHandler2);
        if (fastVector.size() > 0) {
            return ((RuleStats)revisionHandler2).getFiltered(fastVector.size() - 1)[1];
        }
        return instances;
    }

    private boolean checkStop(double[] dArray, double d, double d2) {
        if (d2 > d + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println("DL too large: " + d2 + " | " + d);
            }
            return true;
        }
        if (!Utils.gr(dArray[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println("Too few positives.");
            }
            return true;
        }
        if (dArray[4] / dArray[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println("Error too large: " + dArray[4] + "/" + dArray[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println("Continue.");
        }
        return false;
    }

    public String toString() {
        int n;
        if (this.m_Ruleset == null) {
            return "JRIP: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer("JRIP rules:\n===========\n\n");
        for (n = 0; n < this.m_RulesetStats.size(); ++n) {
            RuleStats ruleStats = (RuleStats)this.m_RulesetStats.elementAt(n);
            FastVector fastVector = ruleStats.getRuleset();
            for (int i = 0; i < fastVector.size(); ++i) {
                double[] dArray = ruleStats.getSimpleStats(i);
                stringBuffer.append(((RipperRule)fastVector.elementAt(i)).toString(this.m_Class) + " (" + dArray[0] + "/" + dArray[4] + ")\n");
            }
        }
        if (this.m_Debug) {
            System.err.println("Inside m_Ruleset");
            for (n = 0; n < this.m_Ruleset.size(); ++n) {
                System.err.println(((RipperRule)this.m_Ruleset.elementAt(n)).toString(this.m_Class));
            }
        }
        stringBuffer.append("\nNumber of Rules : " + this.m_Ruleset.size() + "\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5529 $");
    }

    public static void main(String[] stringArray) {
        JRip.runClassifier(new JRip(), stringArray);
    }

    protected class RipperRule
    extends Rule {
        static final long serialVersionUID = -2410020717305262952L;
        private double m_Consequent = -1.0;
        protected FastVector m_Antds = new FastVector();

        public void setConsequent(double d) {
            this.m_Consequent = d;
        }

        public double getConsequent() {
            return this.m_Consequent;
        }

        public Object copy() {
            RipperRule ripperRule = new RipperRule();
            ripperRule.setConsequent(this.getConsequent());
            ripperRule.m_Antds = (FastVector)this.m_Antds.copyElements();
            return ripperRule;
        }

        public boolean covers(Instance instance) {
            boolean bl = true;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.covers(instance)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        public double size() {
            return this.m_Antds.size();
        }

        private double computeDefAccu(Instances instances) {
            double d = 0.0;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if ((int)instance.classValue() != (int)this.m_Consequent) continue;
                d += instance.weight();
            }
            return d;
        }

        public void grow(Instances instances) throws Exception {
            int n;
            if (this.m_Consequent == -1.0) {
                throw new Exception(" Consequent not set yet.");
            }
            Instances instances2 = instances;
            double d = instances2.sumOfWeights();
            if (!Utils.gr(d, 0.0)) {
                return;
            }
            double d2 = this.computeDefAccu(instances2);
            double d3 = (d2 + 1.0) / (d + 1.0);
            boolean[] blArray = new boolean[instances2.numAttributes()];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            n = blArray.length;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.getAttr().isNumeric()) continue;
                blArray[antd.getAttr().index()] = true;
                --n;
            }
            while (Utils.gr(instances2.numInstances(), 0.0) && n > 0 && Utils.sm(d3, 1.0)) {
                double d4 = 0.0;
                Antd antd = null;
                Instances instances3 = null;
                Enumeration enumeration = instances2.enumerateAttributes();
                while (enumeration.hasMoreElements()) {
                    Instances instances4;
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    if (JRip.this.m_Debug) {
                        System.err.println("\nOne condition: size = " + instances2.sumOfWeights());
                    }
                    Antd antd2 = null;
                    antd2 = attribute.isNumeric() ? new NumericAntd(attribute) : new NominalAntd(attribute);
                    if (blArray[attribute.index()] || (instances4 = this.computeInfoGain(instances2, d3, antd2)) == null) continue;
                    double d5 = antd2.getMaxInfoGain();
                    if (JRip.this.m_Debug) {
                        System.err.println("Test of '" + antd2.toString() + "': infoGain = " + d5 + " | Accuracy = " + antd2.getAccuRate() + "=" + antd2.getAccu() + "/" + antd2.getCover() + " def. accuracy: " + d3);
                    }
                    if (!(d5 > d4)) continue;
                    antd = antd2;
                    instances3 = instances4;
                    d4 = d5;
                }
                if (antd == null || Utils.sm(antd.getAccu(), JRip.this.m_MinNo)) break;
                if (!antd.getAttr().isNumeric()) {
                    blArray[antd.getAttr().index()] = true;
                    --n;
                }
                this.m_Antds.addElement(antd);
                instances2 = instances3;
                d3 = antd.getAccuRate();
            }
        }

        private Instances computeInfoGain(Instances instances, double d, Antd antd) {
            Instances instances2 = instances;
            Instances[] instancesArray = antd.splitData(instances2, d, this.m_Consequent);
            if (instancesArray != null) {
                return instancesArray[(int)antd.getAttrValue()];
            }
            return null;
        }

        public void prune(Instances instances, boolean bl) {
            int n;
            int n2;
            Instances instances2 = instances;
            double d = instances2.sumOfWeights();
            if (!Utils.gr(d, 0.0)) {
                return;
            }
            double d2 = this.computeDefAccu(instances2);
            if (JRip.this.m_Debug) {
                System.err.println("Pruning with " + d2 + " positive data out of " + d + " instances");
            }
            if ((n2 = this.m_Antds.size()) == 0) {
                return;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray3[i] = 0.0;
                dArray2[i] = 0.0;
                dArray[i] = 0.0;
            }
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                Instances instances3 = instances2;
                instances2 = new Instances(instances3, 0);
                for (n = 0; n < instances3.numInstances(); ++n) {
                    Instance instance = instances3.instance(n);
                    if (antd.covers(instance)) {
                        int n3 = i;
                        dArray2[n3] = dArray2[n3] + instance.weight();
                        instances2.add(instance);
                        if ((int)instance.classValue() != (int)this.m_Consequent) continue;
                        int n4 = i;
                        dArray3[n4] = dArray3[n4] + instance.weight();
                        continue;
                    }
                    if (!bl || (int)instance.classValue() == (int)this.m_Consequent) continue;
                    d3 += instance.weight();
                }
                if (bl) {
                    int n5 = i;
                    dArray3[n5] = dArray3[n5] + d3;
                    dArray[i] = dArray3[i] / d;
                    continue;
                }
                dArray[i] = (dArray3[i] + 1.0) / (dArray2[i] + 2.0);
            }
            double d4 = (d2 + 1.0) / (d + 2.0);
            int n6 = -1;
            for (n = 0; n < dArray3.length; ++n) {
                if (JRip.this.m_Debug) {
                    double d5 = bl ? d : dArray2[n];
                    System.err.println(n + "(useAccuray? " + !bl + "): " + dArray[n] + "=" + dArray3[n] + "/" + d5);
                }
                if (!(dArray[n] > d4)) continue;
                d4 = dArray[n];
                n6 = n;
            }
            for (n = n2 - 1; n > n6; --n) {
                this.m_Antds.removeElementAt(n);
            }
        }

        public String toString(Attribute attribute) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int i = 0; i < this.m_Antds.size() - 1; ++i) {
                    stringBuffer.append("(" + ((Antd)this.m_Antds.elementAt(i)).toString() + ") and ");
                }
                stringBuffer.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            stringBuffer.append(" => " + attribute.name() + "=" + attribute.value((int)this.m_Consequent));
            return stringBuffer.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private class NominalAntd
    extends Antd {
        static final long serialVersionUID = -9102297038837585135L;
        private double[] accurate;
        private double[] coverage;

        public NominalAntd(Attribute attribute) {
            super(attribute);
            int n = this.att.numValues();
            this.accurate = new double[n];
            this.coverage = new double[n];
        }

        public Object copy() {
            NominalAntd nominalAntd = new NominalAntd(this.getAttr());
            nominalAntd.value = this.value;
            return nominalAntd;
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            int n;
            int n2 = this.att.numValues();
            Instances[] instancesArray = new Instances[n2];
            for (n = 0; n < n2; ++n) {
                instancesArray[n] = new Instances(instances, instances.numInstances());
                this.accurate[n] = 0.0;
                this.coverage[n] = 0.0;
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                Instance instance = instances.instance(n);
                if (instance.isMissing(this.att)) continue;
                int n3 = (int)instance.value(this.att);
                instancesArray[n3].add(instance);
                int n4 = n3;
                this.coverage[n4] = this.coverage[n4] + instance.weight();
                if ((int)instance.classValue() != (int)d2) continue;
                int n5 = n3;
                this.accurate[n5] = this.accurate[n5] + instance.weight();
            }
            for (n = 0; n < n2; ++n) {
                double d3 = this.accurate[n] + 1.0;
                double d4 = this.coverage[n] + 1.0;
                double d5 = this.accurate[n] * (Utils.log2(d3 / d4) - Utils.log2(d));
                if (!(d5 > this.maxInfoGain)) continue;
                this.maxInfoGain = d5;
                this.cover = this.coverage[n];
                this.accu = this.accurate[n];
                this.accuRate = d3 / d4;
                this.value = n;
            }
            return instancesArray;
        }

        public boolean covers(Instance instance) {
            boolean bl = false;
            if (!instance.isMissing(this.att) && (int)instance.value(this.att) == (int)this.value) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private class NumericAntd
    extends Antd {
        static final long serialVersionUID = 5699457269983735442L;
        private double splitPoint;

        public NumericAntd(Attribute attribute) {
            super(attribute);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        public Object copy() {
            NumericAntd numericAntd = new NumericAntd(this.getAttr());
            numericAntd.value = this.value;
            numericAntd.splitPoint = this.splitPoint;
            return numericAntd;
        }

        public Instances[] splitData(Instances instances, double d, double d2) {
            Instance instance;
            int n;
            Instances instances2 = instances;
            int n2 = instances2.numInstances();
            int n3 = 1;
            int n4 = 0;
            int n5 = n3;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            instances2.sort(this.att);
            for (n = 0; n < instances2.numInstances(); ++n) {
                instance = instances2.instance(n);
                if (instance.isMissing(this.att)) {
                    n2 = n;
                    break;
                }
                d4 += instance.weight();
                if (!Utils.eq(instance.classValue(), d2)) continue;
                d6 += instance.weight();
            }
            if (n2 == 0) {
                return null;
            }
            this.splitPoint = instances2.instance(n2 - 1).value(this.att);
            while (n3 <= n2) {
                if (n3 == n2 || instances2.instance(n3).value(this.att) > instances2.instance(n4).value(this.att)) {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    boolean bl;
                    double d11;
                    for (n = n4; n < n3; ++n) {
                        instance = instances2.instance(n);
                        d3 += instance.weight();
                        if (!Utils.eq(instances2.instance(n).classValue(), d2)) continue;
                        d5 += instance.weight();
                    }
                    double d12 = (d5 + 1.0) / (d3 + 1.0);
                    double d13 = (d6 + 1.0) / (d4 + 1.0);
                    double d14 = d5 * (Utils.log2(d12) - Utils.log2(d));
                    if (d14 > (d11 = d6 * (Utils.log2(d13) - Utils.log2(d)))) {
                        bl = true;
                        d10 = d14;
                        d9 = d12;
                        d8 = d5;
                        d7 = d3;
                    } else {
                        bl = false;
                        d10 = d11;
                        d9 = d13;
                        d8 = d6;
                        d7 = d4;
                    }
                    if (d10 > this.maxInfoGain) {
                        this.splitPoint = instances2.instance(n4).value(this.att);
                        this.value = bl ? 0.0 : 1.0;
                        this.accuRate = d9;
                        this.accu = d8;
                        this.cover = d7;
                        this.maxInfoGain = d10;
                        n5 = bl ? n3 : n4;
                    }
                    for (int i = n4; i < n3; ++i) {
                        Instance instance2 = instances2.instance(i);
                        d4 -= instance2.weight();
                        if (!Utils.eq(instances2.instance(i).classValue(), d2)) continue;
                        d6 -= instance2.weight();
                    }
                    n4 = n3;
                }
                ++n3;
            }
            Instances[] instancesArray = new Instances[]{new Instances(instances2, 0, n5), new Instances(instances2, n5, n2 - n5)};
            return instancesArray;
        }

        public boolean covers(Instance instance) {
            boolean bl = true;
            if (!instance.isMissing(this.att)) {
                if ((int)this.value == 0) {
                    if (instance.value(this.att) > this.splitPoint) {
                        bl = false;
                    }
                } else if (instance.value(this.att) < this.splitPoint) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            String string = (int)this.value == 0 ? " <= " : " >= ";
            return this.att.name() + string + Utils.doubleToString(this.splitPoint, 6);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private abstract class Antd
    implements WeightedInstancesHandler,
    Copyable,
    Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8929754772994154334L;
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute attribute) {
            this.att = attribute;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean covers(Instance var1);

        public abstract String toString();

        public abstract Object copy();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }
}

