/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileWriter {
    public MatFileWriter() {
    }

    public MatFileWriter(String string, Collection<MLArray> collection) throws IOException {
        this(new File(string), collection);
    }

    public MatFileWriter(File file, Collection<MLArray> collection) throws IOException {
        this(new FileOutputStream(file).getChannel(), collection);
    }

    public MatFileWriter(WritableByteChannel writableByteChannel, Collection<MLArray> collection) throws IOException {
        this.write(writableByteChannel, collection);
    }

    public synchronized void write(String string, Collection<MLArray> collection) throws IOException {
        this.write(new File(string), collection);
    }

    public synchronized void write(File file, Collection<MLArray> collection) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.write(fileOutputStream.getChannel(), collection);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            fileOutputStream.close();
        }
    }

    private synchronized void write(WritableByteChannel writableByteChannel, Collection<MLArray> collection) throws IOException {
        try {
            this.writeHeader(writableByteChannel);
            for (MLArray mLArray : collection) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                this.writeMatrix(dataOutputStream, mLArray);
                Deflater deflater = new Deflater();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(new DeflaterOutputStream((OutputStream)byteArrayOutputStream2, deflater));
                dataOutputStream2.write(byArray);
                dataOutputStream2.close();
                byteArrayOutputStream2.close();
                byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 + byArray2.length);
                byteBuffer.putInt(15);
                byteBuffer.putInt(byArray2.length);
                byteBuffer.put(byArray2);
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            writableByteChannel.close();
        }
    }

    private void writeHeader(WritableByteChannel writableByteChannel) throws IOException {
        int n;
        MatFileHeader matFileHeader = MatFileHeader.createHeader();
        char[] cArray = new char[116];
        char[] cArray2 = matFileHeader.getDescription().toCharArray();
        System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
        byte[] byArray = matFileHeader.getEndianIndicator();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(cArray.length * 2 + 2 + byArray.length);
        for (n = 0; n < cArray.length; ++n) {
            byteBuffer.put((byte)cArray[n]);
        }
        byteBuffer.position(byteBuffer.position() + 8);
        n = matFileHeader.getVersion();
        byteBuffer.put((byte)(n >> 8));
        byteBuffer.put((byte)n);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
    }

    private void writeMatrix(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        this.writeFlags(dataOutputStream2, mLArray);
        this.writeDimensions(dataOutputStream2, mLArray);
        this.writeName(dataOutputStream2, mLArray);
        switch (mLArray.getType()) {
            case 4: {
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
                Character[] characterArray = ((MLChar)mLArray).exportChar();
                for (int i = 0; i < characterArray.length; ++i) {
                    dataOutputStream3.writeByte((byte)characterArray[i].charValue());
                }
                OSArrayTag oSArrayTag = new OSArrayTag(16, byteArrayOutputStream2.toByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 6: {
                OSArrayTag oSArrayTag = new OSArrayTag(9, ((MLNumericArray)mLArray).getRealByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                oSArrayTag = new OSArrayTag(9, ((MLNumericArray)mLArray).getImaginaryByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 9: {
                OSArrayTag oSArrayTag = new OSArrayTag(2, ((MLNumericArray)mLArray).getRealByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                oSArrayTag = new OSArrayTag(2, ((MLNumericArray)mLArray).getImaginaryByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 8: {
                OSArrayTag oSArrayTag = new OSArrayTag(1, ((MLNumericArray)mLArray).getRealByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                oSArrayTag = new OSArrayTag(1, ((MLNumericArray)mLArray).getImaginaryByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 14: {
                OSArrayTag oSArrayTag = new OSArrayTag(12, ((MLNumericArray)mLArray).getRealByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                oSArrayTag = new OSArrayTag(12, ((MLNumericArray)mLArray).getImaginaryByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 15: {
                OSArrayTag oSArrayTag = new OSArrayTag(13, ((MLNumericArray)mLArray).getRealByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                oSArrayTag = new OSArrayTag(13, ((MLNumericArray)mLArray).getImaginaryByteBuffer());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            case 2: {
                int n = 262149;
                dataOutputStream2.writeInt(n);
                dataOutputStream2.writeInt(((MLStructure)mLArray).getMaxFieldLenth());
                OSArrayTag oSArrayTag = new OSArrayTag(1, ((MLStructure)mLArray).getKeySetToByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                for (MLArray mLArray2 : ((MLStructure)mLArray).getAllFields()) {
                    this.writeMatrix(dataOutputStream2, mLArray2);
                }
                break;
            }
            case 1: {
                for (MLArray mLArray3 : ((MLCell)mLArray).cells()) {
                    this.writeMatrix(dataOutputStream2, mLArray3);
                }
                break;
            }
            case 5: {
                int[] nArray;
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
                for (int n2 : nArray = ((MLSparse)mLArray).getIR()) {
                    dataOutputStream4.writeInt(n2);
                }
                OSArrayTag oSArrayTag = new OSArrayTag(5, byteArrayOutputStream3.toByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                byteArrayOutputStream3 = new ByteArrayOutputStream();
                dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
                int[] nArray2 = nArray = ((MLSparse)mLArray).getJC();
                int n = nArray2.length;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    n2 = nArray2[i];
                    dataOutputStream4.writeInt(n2);
                }
                oSArrayTag = new OSArrayTag(5, byteArrayOutputStream3.toByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                byteArrayOutputStream3 = new ByteArrayOutputStream();
                dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
                Double[] doubleArray = ((MLSparse)mLArray).exportReal();
                for (n = 0; n < doubleArray.length; ++n) {
                    dataOutputStream4.writeDouble(doubleArray[n]);
                }
                oSArrayTag = new OSArrayTag(9, byteArrayOutputStream3.toByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                if (!mLArray.isComplex()) break;
                byteArrayOutputStream3 = new ByteArrayOutputStream();
                dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
                Double[] doubleArray2 = ((MLSparse)mLArray).exportImaginary();
                for (n = 0; n < doubleArray2.length; ++n) {
                    dataOutputStream4.writeDouble(doubleArray2[n]);
                }
                oSArrayTag = new OSArrayTag(9, byteArrayOutputStream3.toByteArray());
                oSArrayTag.writeTo(dataOutputStream2);
                break;
            }
            default: {
                throw new MatlabIOException("Cannot write matrix of type: " + MLArray.typeToString(mLArray.getType()));
            }
        }
        dataOutputStream.writeInt(14);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    private void writeFlags(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(mLArray.getFlags());
        if (mLArray.isSparse()) {
            dataOutputStream2.writeInt(((MLSparse)mLArray).getMaxNZ());
        } else {
            dataOutputStream2.writeInt(0);
        }
        OSArrayTag oSArrayTag = new OSArrayTag(6, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }

    private void writeDimensions(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int[] nArray = mLArray.getDimensions();
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream2.writeInt(nArray[i]);
        }
        OSArrayTag oSArrayTag = new OSArrayTag(6, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }

    private void writeName(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = mLArray.getNameToByteArray();
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.write(byArray);
        OSArrayTag oSArrayTag = new OSArrayTag(16, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }

    private class OSArrayTag
    extends MatTag {
        private ByteBuffer data;
        private int padding;

        public OSArrayTag(int n, byte[] byArray) {
            this(n, ByteBuffer.wrap(byArray));
        }

        public OSArrayTag(int n, ByteBuffer byteBuffer) {
            super(n, byteBuffer.limit());
            this.data = byteBuffer;
            byteBuffer.rewind();
            this.padding = this.getPadding(byteBuffer.limit(), false);
        }

        public void writeTo(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.type);
            dataOutputStream.writeInt(this.size);
            int n = 1024;
            int n2 = this.data.remaining() < n ? this.data.remaining() : n;
            byte[] byArray = new byte[n2];
            while (this.data.remaining() > 0) {
                int n3 = this.data.remaining() > byArray.length ? byArray.length : this.data.remaining();
                this.data.get(byArray, 0, n3);
                dataOutputStream.write(byArray, 0, n3);
            }
            if (this.padding > 0) {
                dataOutputStream.write(new byte[this.padding]);
            }
        }
    }
}

