/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.common.MatDataTypes;
import com.jmatio.types.ByteStorageSupport;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MatFileInputStream {
    private int type;
    private ByteBuffer buf;

    public MatFileInputStream(ByteBuffer byteBuffer, int n) {
        this.type = n;
        this.buf = byteBuffer;
    }

    public int readInt() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 5: {
                return this.buf.getInt();
            }
            case 13: {
                return (int)this.buf.getLong();
            }
            case 12: {
                return (int)this.buf.getLong();
            }
            case 9: {
                return (int)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public char readChar() throws IOException {
        switch (this.type) {
            case 2: {
                return (char)(this.buf.get() & 0xFF);
            }
            case 1: {
                return (char)this.buf.get();
            }
            case 4: {
                return (char)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return (char)this.buf.getShort();
            }
            case 6: {
                return (char)(this.buf.getInt() & 0xFFFFFFFF);
            }
            case 5: {
                return (char)this.buf.getInt();
            }
            case 9: {
                return (char)this.buf.getDouble();
            }
            case 16: {
                return (char)this.buf.get();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public double readDouble() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 5: {
                return this.buf.getInt();
            }
            case 9: {
                return this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public byte readByte() {
        switch (this.type) {
            case 2: {
                return (byte)(this.buf.get() & 0xFF);
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return (byte)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return (byte)this.buf.getShort();
            }
            case 6: {
                return (byte)(this.buf.getInt() & 0xFFFFFFFF);
            }
            case 5: {
                return (byte)this.buf.getInt();
            }
            case 9: {
                return (byte)this.buf.getDouble();
            }
            case 16: {
                return this.buf.get();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public ByteBuffer readToByteBuffer(ByteBuffer byteBuffer, int n, ByteStorageSupport<?> byteStorageSupport) throws IOException {
        int n2 = byteStorageSupport.getBytesAllocated();
        int n3 = n * byteStorageSupport.getBytesAllocated();
        if (MatDataTypes.sizeOf(this.type) == n2 && this.buf.order().equals(byteBuffer.order())) {
            int n4 = 1024;
            int n5 = Math.min(this.buf.remaining(), n4);
            int n6 = this.buf.position();
            byte[] byArray = new byte[n5];
            while (byteBuffer.remaining() > 0) {
                int n7 = Math.min(byteBuffer.remaining(), byArray.length);
                this.buf.get(byArray, 0, n7);
                byteBuffer.put(byArray, 0, n7);
            }
            this.buf.position(n6 + n3);
        } else {
            Class<?> clazz = byteStorageSupport.getStorageClazz();
            while (byteBuffer.remaining() > 0) {
                if (clazz.equals(Double.class)) {
                    byteBuffer.putDouble(this.readDouble());
                    continue;
                }
                if (clazz.equals(Byte.class)) {
                    byteBuffer.put(this.readByte());
                    continue;
                }
                if (clazz.equals(Integer.class)) {
                    byteBuffer.putInt(this.readInt());
                    continue;
                }
                if (clazz.equals(Long.class)) {
                    byteBuffer.putLong(this.readLong());
                    continue;
                }
                throw new RuntimeException("Not supported buffer reader for " + clazz);
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private long readLong() {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 5: {
                return this.buf.getInt();
            }
            case 13: {
                return this.buf.getLong();
            }
            case 12: {
                return this.buf.getLong();
            }
            case 9: {
                return (long)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }
}

