/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojavax.DocRefAuthor;
import org.biojavax.RichObjectBuilder;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.ontology.SimpleComparableOntology;

public class BioSQLRichObjectBuilder
implements RichObjectBuilder {
    private Object session;
    private Method createQuery;
    private Method setParameter;
    private Method uniqueResult;
    private Method persist;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;

    public BioSQLRichObjectBuilder(Object session) {
        try {
            Class<?> hibernateSession = session.getClass();
            Class<?> realHibernateSession = Class.forName("org.hibernate.Session");
            if (!realHibernateSession.isAssignableFrom(hibernateSession)) {
                throw new IllegalArgumentException("Parameter must be a org.hibernate.Session object");
            }
            this.session = session;
            this.createQuery = hibernateSession.getMethod("createQuery", String.class);
            this.persist = hibernateSession.getMethod("persist", String.class, Object.class);
            Class<?> hibernateQuery = Class.forName("org.hibernate.Query");
            this.setParameter = hibernateQuery.getMethod("setParameter", Integer.TYPE, Object.class);
            this.uniqueResult = hibernateQuery.getMethod("uniqueResult", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Object buildObject(Class clazz, List paramsList) {
        String queryType;
        String queryText;
        ArrayList<String> ourParamsList = new ArrayList<String>(paramsList);
        Iterator i = ourParamsList.iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        if (SimpleNamespace.class.isAssignableFrom(clazz)) {
            queryText = "from Namespace as ns where ns.name = ?";
            queryType = "Namespace";
        } else if (SimpleComparableOntology.class.isAssignableFrom(clazz)) {
            queryText = "from Ontology as o where o.name = ?";
            queryType = "Ontology";
        } else if (SimpleNCBITaxon.class.isAssignableFrom(clazz)) {
            queryText = "from Taxon as o where o.NCBITaxID = ?";
            queryType = "Taxon";
        } else if (SimpleCrossRef.class.isAssignableFrom(clazz)) {
            queryText = "from CrossRef as cr where cr.dbname = ? and cr.accession = ? and cr.version = ?";
            queryType = "CrossRef";
        } else if (SimpleDocRef.class.isAssignableFrom(clazz)) {
            queryType = "DocRef";
            ourParamsList.set(0, DocRefAuthor.Tools.generateAuthorString((List)ourParamsList.get(0)));
            queryText = ourParamsList.size() < 3 ? "from DocRef as cr where cr.authors = ? and cr.location = ? and cr.title is null" : "from DocRef as cr where cr.authors = ? and cr.location = ? and cr.title = ?";
        } else {
            throw new IllegalArgumentException("Don't know how to handle objects of type " + clazz);
        }
        try {
            Object query = this.createQuery.invoke(this.session, queryText);
            for (int i2 = 0; i2 < ourParamsList.size(); ++i2) {
                query = this.setParameter.invoke(query, new Integer(i2), ourParamsList.get(i2));
            }
            Object result = this.uniqueResult.invoke(query, null);
            if (result != null) {
                return result;
            }
            Class[] types = new Class[ourParamsList.size()];
            for (int i3 = 0; i3 < ourParamsList.size(); ++i3) {
                types[i3] = ourParamsList.get(i3) instanceof Set ? (class$java$util$Set == null ? BioSQLRichObjectBuilder.class$("java.util.Set") : class$java$util$Set) : (ourParamsList.get(i3) instanceof Map ? (class$java$util$Map == null ? BioSQLRichObjectBuilder.class$("java.util.Map") : class$java$util$Map) : (ourParamsList.get(i3) instanceof List ? (class$java$util$List == null ? BioSQLRichObjectBuilder.class$("java.util.List") : class$java$util$List) : ourParamsList.get(i3).getClass()));
            }
            Constructor c = clazz.getConstructor(types);
            Object o = c.newInstance(ourParamsList.toArray());
            this.persist.invoke(this.session, queryType, o);
            return o;
        }
        catch (Exception e) {
            StringBuffer paramsstuff = new StringBuffer();
            paramsstuff.append(clazz);
            paramsstuff.append("(");
            for (int i4 = 0; i4 < ourParamsList.size(); ++i4) {
                if (i4 > 0) {
                    paramsstuff.append(",");
                }
                paramsstuff.append(ourParamsList.get(i4).getClass());
            }
            paramsstuff.append(")");
            throw new RuntimeException("Error while trying to call new " + paramsstuff, e);
        }
    }
}

