/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBParseException;

public class AminoAcidImpl
extends HetatomImpl
implements AminoAcid {
    public static final String type = "amino";
    Character amino_char = null;
    HashMap secstruc = new HashMap();

    public String getType() {
        return type;
    }

    public void setSecStruc(Map secstr) {
        this.secstruc = (HashMap)secstr;
    }

    public Map getSecStruc() {
        return this.secstruc;
    }

    public Atom getN() throws StructureException {
        return this.getAtom("N");
    }

    public Atom getCA() throws StructureException {
        return this.getAtom("CA");
    }

    public Atom getC() throws StructureException {
        return this.getAtom("C");
    }

    public Atom getO() throws StructureException {
        return this.getAtom("O");
    }

    public Atom getCB() throws StructureException {
        return this.getAtom("CB");
    }

    public Character getAminoType() {
        return this.amino_char;
    }

    public void setAminoType(Character aa) {
        this.amino_char = aa;
    }

    public String toString() {
        String str = "PDB: " + this.pdb_name + " " + this.amino_char + " " + this.pdb_code + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + "atoms: " + this.atoms.size();
        }
        return str;
    }

    public void setPDBName(String s) throws PDBParseException {
        if (s.length() != 3) {
            throw new PDBParseException("amino acid name is not of length 3! (" + s + ")");
        }
        this.pdb_name = s;
    }

    public Object clone() {
        AminoAcidImpl n = new AminoAcidImpl();
        n.setPDBFlag(this.has3D());
        n.setPDBCode(this.getPDBCode());
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        n.setAminoType(this.getAminoType());
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }
}

