/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.LayoutMutable;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.interfaces.CanRenderGraph;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.jung.DefaultShapePickSupport;
import org.ujmp.jung.JungGraphActions;

public abstract class JungGraphPanel
extends VisualizationViewer
implements MouseListener,
ComponentListener,
GraphEventListener,
CanBeRepainted,
CanRenderGraph {
    private static final long serialVersionUID = 5056858150031378990L;
    protected static final Logger logger = Logger.getLogger(JungGraphPanel.class.getName());
    protected Graph graph = new DirectedSparseGraph();
    private boolean showEdges = true;
    private boolean showEdgeLabels = true;
    private boolean showVertexLabels = true;
    private BufferedImage bufferedImage = null;

    public JungGraphPanel() {
        super((VisualizationModel)new DefaultVisualizationModel((Layout)new FRLayout((Graph)new DirectedSparseGraph())), (Renderer)new PluggableRenderer(), new Dimension(800, 600));
        this.addComponentListener(this);
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(800, 600));
        this.addMouseListener(this);
        this.setPickSupport((PickSupport)new DefaultShapePickSupport());
        this.addPostRenderPaintable(new VisualizationViewer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;

            public void paint(Graphics g) {
            }

            public boolean useTransform() {
                return false;
            }
        });
        ((PluggableRenderer)this.getRenderer()).setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.QuadCurve());
        ((PluggableRenderer)this.getRenderer()).setVertexStringer(new VertexStringer(){

            public String getLabel(ArchetypeVertex v) {
                if (JungGraphPanel.this.isShowVertexLabels() && v.getUserDatum((Object)Data.Label) != null) {
                    return "" + v.getUserDatum((Object)Data.Label);
                }
                return null;
            }
        });
        ((PluggableRenderer)this.getRenderer()).setEdgeStringer(new EdgeStringer(){

            public String getLabel(ArchetypeEdge e) {
                if (JungGraphPanel.this.isShowEdgeLabels() && e.getUserDatum((Object)Data.Label) != null) {
                    return "" + e.getUserDatum((Object)Data.Label);
                }
                return null;
            }
        });
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        this.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void componentShown(ComponentEvent e) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void setGraph(Graph g) {
        this.graph.removeListener((GraphEventListener)this, (GraphEventType)GraphEventType.ALL_SINGLE_EVENTS);
        this.graph = g;
        this.graph.addListener((GraphEventListener)this, (GraphEventType)GraphEventType.ALL_SINGLE_EVENTS);
        this.setModel((VisualizationModel)new DefaultVisualizationModel((Layout)new FRLayout(this.graph)));
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void renderGraph(Graphics2D g2d) {
        super.renderGraph(g2d);
    }

    public final void repaintUI() {
        if (this.getModel().getGraphLayout() instanceof LayoutMutable) {
            ((LayoutMutable)this.getModel().getGraphLayout()).update();
        }
        if (!this.isVisRunnerRunning()) {
            try {
                this.init();
            }
            catch (FatalException e) {
                System.out.println("Fatal Error in JungGraphPanel");
            }
        }
        BufferedImage tempBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = tempBufferedImage.getGraphics();
        super.paintComponent(g);
        g.dispose();
        this.bufferedImage = tempBufferedImage;
    }

    public void paintComponent(Graphics g) {
        if (this.ui != null) {
            Graphics scratchGraphics = g == null ? null : g.create();
            try {
                this.ui.update(scratchGraphics, (JComponent)((Object)this));
            }
            finally {
                scratchGraphics.dispose();
            }
        }
        if (this.bufferedImage != null) {
            g.drawImage(this.bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            g.setColor(Color.GRAY);
            g.drawLine(0, 0, this.getWidth(), this.getHeight());
            g.drawLine(this.getWidth(), 0, 0, this.getHeight());
            GraphicsExecutor.scheduleUpdate(this);
        }
    }

    public final boolean isShowEdges() {
        return this.showEdges;
    }

    public final void setShowEdges(boolean showEdges) {
        this.showEdges = showEdges;
    }

    public final boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    public final void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
    }

    public final boolean isShowVertexLabels() {
        return this.showVertexLabels;
    }

    public final void setShowVertexLabels(boolean showVertexLabels) {
        this.showVertexLabels = showVertexLabels;
    }

    public final void exportToPDF(File file) {
        Color oldbg = this.getBackground();
        this.setBackground(Color.white);
        ExportPDF.save(file, (Component)((Object)this));
        this.setBackground(oldbg);
    }

    public final void exportToJPEG(File file) {
        Color oldbg = this.getBackground();
        this.setBackground(Color.white);
        ExportJPEG.save(file, (Component)((Object)this), 1600);
        this.setBackground(oldbg);
    }

    public final void exportToPNG(File file) {
        Color oldbg = this.getBackground();
        this.setBackground(Color.white);
        ExportPNG.save(file, (Component)((Object)this), 1600);
        this.setBackground(oldbg);
    }

    public final void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                JungGraphActions popup = null;
                popup = new JungGraphActions(this);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public final void mousePressed(MouseEvent e) {
    }

    public final void mouseReleased(MouseEvent e) {
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }

    public void switchLayout(GraphLayout type) {
        this.stop();
        KKLayout layout = null;
        switch (type) {
            case KKLayout: {
                layout = new KKLayout(this.graph);
                break;
            }
            case FRLayout: {
                layout = new FRLayout(this.graph);
                break;
            }
            case ISOMLayout: {
                layout = new ISOMLayout(this.graph);
                break;
            }
            case SpringLayout: {
                layout = new SpringLayout(this.graph);
                break;
            }
            case CircleLayout: {
                layout = new CircleLayout(this.graph);
            }
        }
        this.setModel((VisualizationModel)new DefaultVisualizationModel(layout));
        this.restart();
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void edgeAdded(GraphEvent event) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void edgeRemoved(GraphEvent event) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void vertexAdded(GraphEvent event) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    public void vertexRemoved(GraphEvent event) {
        GraphicsExecutor.scheduleUpdate(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Data {
        JDMPObject,
        Object,
        Label,
        Column,
        RowColumn,
        Value,
        Inhibitory,
        Excitatory,
        Time,
        Matrix,
        Type,
        Reference;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphLayout {
        FRLayout,
        KKLayout,
        ISOMLayout,
        SpringLayout,
        CircleLayout;

    }
}

