/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.ujmp.gui.plot.PlotSettings;

public class RunningAveragePlot {
    private PlotSettings plotSettings = null;

    public RunningAveragePlot(PlotSettings plotSettings) {
        this.plotSettings = plotSettings;
    }

    public void paintComponent(Graphics g) {
        try {
            long t0 = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            double xf = this.plotSettings.getXFactor();
            double yf = this.plotSettings.getYFactor();
            if (this.plotSettings.getMatrixGUIObject().getRowCount() < 2) {
                return;
            }
            int t = 0;
            while (t < Math.min(10, this.plotSettings.getMatrixGUIObject().getColumnCount())) {
                long t1;
                if (this.plotSettings.isShowTrace(t)) {
                    double sum;
                    double average;
                    long column = t;
                    g2d.setStroke(this.plotSettings.getRunningAverageStroke());
                    g2d.setColor(this.plotSettings.getRunningAverageLineColor());
                    double xs = this.plotSettings.getXStepSize();
                    double oldAverage = average = (sum = this.plotSettings.getMatrixGUIObject().getDoubleValueAt((long)this.plotSettings.getMinXValue(), column).doubleValue());
                    double firstPoint = this.plotSettings.getMinXValue();
                    double nmbOfPoints = 1.0;
                    long dots = 0L;
                    double xr = this.plotSettings.getMinXValue() + xs;
                    while (xr <= this.plotSettings.getMaxXValue()) {
                        ++dots;
                        long row1 = (long)(xr - xs);
                        long row2 = (long)xr;
                        long rowRA = (long)firstPoint;
                        double yv1 = this.plotSettings.getMatrixGUIObject().getDoubleValueAt(row1, column);
                        double yv2 = this.plotSettings.getMatrixGUIObject().getDoubleValueAt(row2, column);
                        double yvRA = this.plotSettings.getMatrixGUIObject().getDoubleValueAt(rowRA, column);
                        sum += yv2;
                        if ((nmbOfPoints += 1.0) > (double)this.plotSettings.getRunningAverageLength() / xs) {
                            sum -= yvRA;
                            firstPoint += xs;
                            nmbOfPoints -= 1.0;
                        }
                        average = sum / nmbOfPoints;
                        int x2 = (int)(xr * xf);
                        int x1 = (int)((xr - xs) * xf);
                        x2 = x2 == x1 ? x2++ : x2;
                        int y1 = (int)((double)(this.plotSettings.getHeight() - 1) - oldAverage * yf + this.plotSettings.getMinYValue() * yf);
                        int y2 = (int)((double)(this.plotSettings.getHeight() - 1) - average * yf + this.plotSettings.getMinYValue() * yf);
                        g2d.drawLine(x1, y1, x2, y2);
                        oldAverage = average;
                        xr += xs;
                    }
                }
                if ((t1 = System.currentTimeMillis()) - t0 > this.plotSettings.getTimeLimit()) {
                    return;
                }
                ++t;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

