/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import javax.swing.JComponent;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.actions.AbstractMatrixAction;
import org.ujmp.gui.actions.Complex;

public class MandelbrotMatrixAction
extends AbstractMatrixAction {
    private static final long serialVersionUID = 8708344146012762782L;

    public MandelbrotMatrixAction(JComponent c, MatrixGUIObject m, GUIObject v) {
        super(c, m, v);
        this.putValue("Name", "Mandelbrot Matrix");
        this.putValue("ShortDescription", "creates a matrix from the mandelbrot set");
    }

    public Object call() throws MatrixException {
        double xoffset = -0.5;
        double yoffset = 0.0;
        double size = 2.0;
        int cells = 500;
        int iterations = 20;
        Matrix m = Matrix.factory.zeros(cells, cells);
        int column = 0;
        while (column < cells) {
            int row = 0;
            while (row < cells) {
                double x0 = xoffset - size / 2.0 + size * (double)column / (double)cells;
                double y0 = yoffset - size / 2.0 + size * (double)row / (double)cells;
                Complex z0 = new Complex(x0, y0);
                double gray = iterations - this.calc(z0, iterations);
                m.setAsDouble((gray - (double)(iterations / 2)) / (double)(iterations / 2), cells - 1 - row, column);
                ++row;
            }
            ++column;
        }
        m.showGUI();
        return m;
    }

    public int calc(Complex c, int iterations) {
        Complex z = c;
        int i = 0;
        while (i < iterations) {
            if (z.abs() > 2.0) {
                return i;
            }
            z = z.times(z).plus(c);
            ++i;
        }
        return iterations;
    }
}

