/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveWords
extends AbstractStringCalculation {
    private static final long serialVersionUID = 4976043243302036392L;
    public Set<String> wordsToRemove = null;

    public RemoveWords(Matrix m, Collection<String> words) {
        super(m);
        this.wordsToRemove = words instanceof Set ? (Set<Object>)words : new HashSet<String>(words);
    }

    @Override
    public String getString(long ... coordinates) throws MatrixException {
        String s = this.getSource().getAsString(coordinates);
        if (s != null) {
            StringBuilder result = new StringBuilder(s.length());
            String[] words = s.split("\\s+");
            int i = 0;
            while (i < words.length) {
                String w = words[i];
                if (w.length() != 0) {
                    if (!this.wordsToRemove.contains(w)) {
                        result.append(w);
                    }
                    if (i < words.length - 1) {
                        result.append(" ");
                    }
                }
                ++i;
            }
            return result.toString();
        }
        return "";
    }
}

