/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;

public class ServerObjectMatrixUDP
extends AbstractSparseObjectMatrix {
    private static final long serialVersionUID = 3907994158174208114L;
    private static final int BUFFERSIZE = 512;
    public static final int GETDOUBLEVALUE = 0;
    public static final int SETDOUBLEVALUE = 1;
    public static final int GETDIMENSIONCOUNT = 2;
    private Matrix matrix = null;
    private DatagramSocket socket = null;
    private DatagramPacket receivedPacket = null;
    private ServerThread thread = null;

    public ServerObjectMatrixUDP(Matrix matrix, int port) {
        this.matrix = matrix;
        try {
            this.receivedPacket = new DatagramPacket(new byte[512], 512);
            this.thread = new ServerThread();
            this.socket = new DatagramSocket(port);
            this.thread.start();
        }
        catch (Exception e) {
            throw new MatrixException("could not open socket", e);
        }
    }

    public long[] getSize() {
        return this.matrix.getSize();
    }

    public double getAsDouble(long ... coordinates) throws MatrixException {
        return this.matrix.getAsDouble(coordinates);
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        return this.matrix.getAsObject(coordinates);
    }

    public long getValueCount() {
        return this.matrix.getValueCount();
    }

    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.matrix.setAsDouble(value, coordinates);
    }

    public void setObject(Object o, long ... coordinates) throws MatrixException {
        this.matrix.setAsObject(o, coordinates);
    }

    public boolean contains(long ... coordinates) {
        return this.matrix.contains(coordinates);
    }

    public boolean isReadOnly() {
        return this.matrix.isReadOnly();
    }

    class ServerThread
    extends Thread {
        public void run() {
            try {
                while (true) {
                    ServerObjectMatrixUDP.this.socket.receive(ServerObjectMatrixUDP.this.receivedPacket);
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ServerObjectMatrixUDP.this.receivedPacket.getData()));
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    int command = ois.readInt();
                    Coordinates coordinates = null;
                    double value = 0.0;
                    switch (command) {
                        case 1: {
                            coordinates = (Coordinates)ois.readObject();
                            value = ois.readDouble();
                            ServerObjectMatrixUDP.this.setAsDouble(value, coordinates.co);
                            oos.writeInt(1);
                            break;
                        }
                        case 0: {
                            coordinates = (Coordinates)ois.readObject();
                            value = ServerObjectMatrixUDP.this.getAsDouble(coordinates.co);
                            oos.writeInt(0);
                            oos.writeDouble(value);
                            break;
                        }
                        case 2: {
                            int dimension = ois.readInt();
                            int result = (int)ServerObjectMatrixUDP.this.getSize(dimension);
                            oos.writeInt(2);
                            oos.writeInt(result);
                        }
                    }
                    oos.flush();
                    DatagramPacket sentPacket = new DatagramPacket(bos.toByteArray(), bos.size(), ServerObjectMatrixUDP.this.receivedPacket.getAddress(), ServerObjectMatrixUDP.this.receivedPacket.getPort());
                    ServerObjectMatrixUDP.this.socket.send(sentPacket);
                }
            }
            catch (Exception e) {
                throw new MatrixException("error in data transmission", e);
            }
        }
    }
}

