/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public class Convert {
    private static final long serialVersionUID = 6393277198816850597L;

    public static Matrix calcNew(ValueType valueType, Matrix source) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(valueType, source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsObject(source.getAsObject(c), c);
        }
        Annotation a = source.getAnnotation();
        if (a != null) {
            ret.setAnnotation(a.clone());
        }
        return ret;
    }

    public static Matrix calcNew(Matrix matrix) throws MatrixException {
        return Convert.calcNew(matrix.getValueType(), matrix);
    }
}

