/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.enums;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.ujmp.core.util.io.UJMPFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat {
    CSV("Comma Separated Files", "csv"),
    TXT("Text Files", "txt"),
    M("Matlab Script Files", "m"),
    MAT("Matlab Data Files", "mat"),
    GIF("GIF Image Files", "gif"),
    FILE("Text Files", "*"),
    MDB("Microsoft Access Files", "mdb"),
    R("R Files", "r"),
    RSS("RSS Feed", "rss", "rdf", "xml"),
    ATOM("Atom Feed", "atom", "xml"),
    JPG("JPG Image Files", "jpg", "jpeg"),
    HTML("HTML Files", "html", "htm"),
    MTX("Matrix Data Format", "mtx"),
    XLS("Microsoft Excel Files", "xls"),
    SER("Serialized Data Files", "ser", "obj", "dat"),
    GRAPHML("GraphML Files", "graphml", "gml"),
    TEX("Latex Files", "tex"),
    WAV("Wave Audio Files", "wav"),
    BMP("BMP Image Files", "bmp"),
    TIFF("TIFF Image Files", "tif"),
    PLT("GnuPlot Files", "plt"),
    PDF("PDF Files", "pdf"),
    PNG("PNG Images Files", "png"),
    XML("XML Files", "xml"),
    AML("AML Files", "aml"),
    ARFF("ARFF Files", "arf"),
    ATT("ATT Files", "att"),
    LOG("Log Files", "log"),
    NET("Net Files", "net"),
    STRING("String files", "txt"),
    SPARSECSV("Sparse CSV Files", "csv"),
    RAW("Binary Files", "raw", "bin"),
    ImapMessages("Imap Messages", "imap"),
    ImapFolders("Imap Folders", "imap");

    private String[] extensions = null;
    private String description = null;
    private FileFilter fileFilter = null;

    private FileFormat(String description, String ... extensions) {
        this.extensions = extensions;
        this.description = description;
        this.fileFilter = new UJMPFileFilter(this.getDescription(), this.getExtensions());
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public String getDescription() {
        return this.description;
    }

    public static FileFormat guess(File file) {
        String name = file.getName().toLowerCase();
        FileFormat[] fileFormatArray = FileFormat.values();
        int n = fileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFormat f = fileFormatArray[n2];
            String[] stringArray = f.getExtensions();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String e = stringArray[n4];
                if (name.endsWith(e)) {
                    return f;
                }
                ++n4;
            }
            ++n2;
        }
        return TXT;
    }
}

