/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransposeDenseMatrix
implements TransposeCalculation<DenseMatrix, DenseMatrix> {
    TransposeDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            Transpose.DENSEMATRIX2D.calc((DenseMatrix2D)source, (DenseMatrix2D)target);
        } else {
            VerifyUtil.assert2D(source);
            VerifyUtil.assert2D(target);
            VerifyUtil.assertEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
            VerifyUtil.assertEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
            for (long[] c : source.allCoordinates()) {
                Object o = source.getAsObject(c);
                target.setAsObject(o, Coordinates.transpose(c));
            }
        }
    }
}

