/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jampack;

import Jampack.Eig;
import Jampack.H;
import Jampack.Inv;
import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Pivot;
import Jampack.Solve;
import Jampack.Times;
import Jampack.Z;
import Jampack.Zchol;
import Jampack.Zludpp;
import Jampack.Zmat;
import Jampack.Zqrd;
import Jampack.Zsvd;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JampackDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Zmat> {
    private static final long serialVersionUID = 4929284378405884509L;
    private transient Zmat matrix = null;

    static {
        try {
            Parameters.setBaseIndex((int)0);
        }
        catch (JampackException e) {
            e.printStackTrace();
        }
    }

    public JampackDenseDoubleMatrix2D(long ... size) {
        this.matrix = new Zmat((int)size[0], (int)size[1]);
    }

    public JampackDenseDoubleMatrix2D(Zmat matrix) {
        this.matrix = matrix;
    }

    public JampackDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public Matrix inv() throws MatrixException {
        try {
            return new JampackDenseDoubleMatrix2D(Inv.o((Zmat)this.matrix));
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)((int)row), (int)((int)column)).re;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get((int)row, (int)column).re;
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.nr, this.matrix.nc};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.put((int)row, (int)column, new Z(value, 0.0));
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.put(row, column, new Z(value, 0.0));
    }

    @Override
    public Zmat getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(Zmat object) {
        this.matrix = object;
    }

    @Override
    public final Matrix copy() throws MatrixException {
        JampackDenseDoubleMatrix2D m = new JampackDenseDoubleMatrix2D(new Zmat(this.matrix));
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public Matrix transpose() {
        return new JampackDenseDoubleMatrix2D(H.trans((Zmat)this.matrix));
    }

    @Override
    public Matrix[] svd() {
        if (this.isSquare()) {
            try {
                Zsvd svd = new Zsvd(this.matrix);
                JampackDenseDoubleMatrix2D u = new JampackDenseDoubleMatrix2D(svd.U);
                JampackDenseDoubleMatrix2D s = new JampackDenseDoubleMatrix2D(new Zmat(svd.S));
                JampackDenseDoubleMatrix2D v = new JampackDenseDoubleMatrix2D(svd.V);
                return new Matrix[]{u, s, v};
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        return super.svd();
    }

    @Override
    public Matrix[] qr() {
        try {
            Zqrd qr = new Zqrd(this.matrix);
            JampackDenseDoubleMatrix2D q = new JampackDenseDoubleMatrix2D(qr.Q);
            JampackDenseDoubleMatrix2D r = new JampackDenseDoubleMatrix2D((Zmat)qr.R);
            return new Matrix[]{q, r};
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix[] lu() {
        try {
            Zludpp lu = new Zludpp(this.matrix);
            JampackDenseDoubleMatrix2D l = new JampackDenseDoubleMatrix2D((Zmat)lu.L);
            JampackDenseDoubleMatrix2D u = new JampackDenseDoubleMatrix2D((Zmat)lu.U);
            int m = (int)this.getRowCount();
            JampackDenseDoubleMatrix2D eye = new JampackDenseDoubleMatrix2D(m, m);
            eye.eye(Calculation.Ret.ORIG);
            JampackDenseDoubleMatrix2D p = new JampackDenseDoubleMatrix2D(Pivot.row((Zmat)eye.getWrappedObject(), (int[])lu.pvt));
            return new Matrix[]{l, u, p};
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix[] eig() {
        try {
            Eig eig = new Eig(this.matrix);
            JampackDenseDoubleMatrix2D v = new JampackDenseDoubleMatrix2D(eig.X);
            JampackDenseDoubleMatrix2D d = new JampackDenseDoubleMatrix2D(new Zmat(eig.D));
            return new Matrix[]{v, d};
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix chol() {
        try {
            Zchol chol = new Zchol(this.matrix);
            JampackDenseDoubleMatrix2D r = new JampackDenseDoubleMatrix2D((Zmat)chol.R);
            return r;
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix mtimes(Matrix m) {
        try {
            if (m instanceof JampackDenseDoubleMatrix2D) {
                return new JampackDenseDoubleMatrix2D(Times.o((Zmat)this.matrix, (Zmat)((JampackDenseDoubleMatrix2D)m).matrix));
            }
            return super.mtimes(m);
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix times(double value) {
        try {
            return new JampackDenseDoubleMatrix2D(Times.o((Z)new Z(value, 0.0), (Zmat)this.matrix));
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public Matrix divide(double value) {
        try {
            return new JampackDenseDoubleMatrix2D(Times.o((Z)new Z(1.0 / value, 0.0), (Zmat)this.matrix));
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = new Zmat(values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.matrix.getRe());
    }

    @Override
    public Matrix solve(Matrix b) {
        try {
            if (this.isSquare() && b instanceof JampackDenseDoubleMatrix2D) {
                JampackDenseDoubleMatrix2D b2 = (JampackDenseDoubleMatrix2D)b;
                Zmat x = Solve.aib((Zmat)this.matrix, (Zmat)b2.matrix);
                return new JampackDenseDoubleMatrix2D(x);
            }
            throw new MatrixException("only supported for square matrices");
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
    }
}

