/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.ujmp.gui.plot.PlotSettings;

public class Traces {
    private PlotSettings plotSettings = null;

    public Traces(PlotSettings plotSettings) {
        this.plotSettings = plotSettings;
    }

    public void paintComponent(Graphics g) {
        try {
            long t0 = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            double xf = this.plotSettings.getXFactor();
            double yf = this.plotSettings.getYFactor();
            int t = 0;
            while (t < Math.min(10, this.plotSettings.getMatrixGUIObject().getColumnCount())) {
                long t1;
                if (this.plotSettings.isShowTrace(t)) {
                    long column = t;
                    g2d.setStroke(this.plotSettings.getTraceStroke(t));
                    g2d.setColor(this.plotSettings.getTraceColor(t));
                    double xs = this.plotSettings.getXStepSize();
                    long dots = 0L;
                    double xr = this.plotSettings.getMinXValue() + xs;
                    while (xr <= this.plotSettings.getMaxXValue()) {
                        ++dots;
                        long row1 = (long)(xr - xs);
                        long row2 = (long)xr;
                        double yv1 = this.plotSettings.getMatrixGUIObject().getDoubleValueAt(row1, column);
                        double yv2 = this.plotSettings.getMatrixGUIObject().getDoubleValueAt(row2, column);
                        int x2 = (int)(xr * xf);
                        int x1 = (int)((xr - xs) * xf);
                        x2 = x2 == x1 ? x2++ : x2;
                        int y1 = (int)((double)(this.plotSettings.getHeight() - 1) - yv1 * yf + this.plotSettings.getMinYValue() * yf);
                        int y2 = (int)((double)(this.plotSettings.getHeight() - 1) - yv2 * yf + this.plotSettings.getMinYValue() * yf);
                        g2d.drawLine(x1, y1, x2, y2);
                        xr += xs;
                    }
                }
                if ((t1 = System.currentTimeMillis()) - t0 > this.plotSettings.getTimeLimit()) {
                    return;
                }
                ++t;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

