/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.actions;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.ObjectAction;

public class DenseMatrixAction
extends ObjectAction {
    private static final long serialVersionUID = 8315118041433423085L;

    public DenseMatrixAction(JComponent c, GUIObject o) {
        super(c, o);
        this.putValue("Name", "Dense Matrix...");
        this.putValue("ShortDescription", "Creates an empty dense matrix");
        this.putValue("MnemonicKey", 68);
    }

    public Object call() {
        try {
            ValueType valueType = ValueType.values()[JOptionPane.showOptionDialog(this.getComponent(), "Select the value type for the new matrix", "Sparse Matrix", 0, 3, null, (Object[])ValueType.values(), (Object)ValueType.DOUBLE)];
            long[] size = null;
            while (size == null || size.length < 2) {
                String s = JOptionPane.showInputDialog(this.getComponent(), "Enter the size of the new matrix, e.g. 3x5x6", "Dense Matrix", 3);
                try {
                    size = Coordinates.parseString(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Matrix m = MatrixFactory.dense(valueType, size);
            m.showGUI();
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

