/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.StringMatrix;
import org.ujmp.core.stringmatrix.calculation.StringCalculation;
import org.ujmp.core.stringmatrix.impl.StringCalculationMatrix;

public abstract class AbstractStringCalculation
extends AbstractCalculation
implements StringCalculation {
    private static final long serialVersionUID = 6467659591327635319L;

    public AbstractStringCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractStringCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final StringMatrix calcLink() throws MatrixException {
        return new StringCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsString(this.getString(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public final StringMatrix calcNew() throws MatrixException {
        StringMatrix result = (StringMatrix)MatrixFactory.zeros(ValueType.STRING, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsString(this.getString(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public void setString(String value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.STRING;
    }
}

