/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.stub;

import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.objectmatrix.impl.DefaultDenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.CoordinateIterator2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapToTiledMatrix2DWrapper
extends AbstractDenseObjectMatrix2D
implements ObjectMatrix2D,
Wrapper<Map<Coordinates, ObjectMatrix2D>> {
    private static final long serialVersionUID = -7464578359102479614L;
    private final long[] tileSize = new long[]{50L, 50L};
    private long[] size = null;
    private final Map<Coordinates, ObjectMatrix2D> values;

    public AbstractMapToTiledMatrix2DWrapper(Map<Coordinates, ObjectMatrix2D> map, long ... size) {
        this.values = map;
        this.size = Coordinates.copyOf(size);
    }

    public AbstractMapToTiledMatrix2DWrapper(Map<Coordinates, ObjectMatrix2D> map, Matrix source) {
        this(map, source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setObject(source.getAsObject(c), c);
            if (MathUtil.equals(this.getObject(c), source.getAsObject(c))) continue;
            throw new MatrixException("error");
        }
    }

    @Override
    public synchronized Object getObject(int row, int column) throws MatrixException {
        return this.getObject((long)row, (long)column);
    }

    public final Map<Coordinates, ObjectMatrix2D> getMap() {
        return this.values;
    }

    @Override
    public synchronized Object getObject(long row, long column) throws MatrixException {
        Coordinates c = new Coordinates(row / this.tileSize[0], column / this.tileSize[1]);
        Matrix m = this.getMap().get(c);
        if (m == null) {
            return null;
        }
        return m.getAsObject(row % this.tileSize[0], column % this.tileSize[1]);
    }

    @Override
    public final Map<Coordinates, ObjectMatrix2D> getWrappedObject() {
        return this.getMap();
    }

    @Override
    public final void setWrappedObject(Map<Coordinates, ObjectMatrix2D> object) {
        throw new MatrixException("cannot change map");
    }

    @Override
    public Iterable<long[]> allCoordinates() {
        return new CoordinateIterator2D(this.getSize());
    }

    @Override
    public final synchronized double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public final synchronized void setAsDouble(double v, long ... coordinates) throws MatrixException {
        this.setObject((Object)v, coordinates);
    }

    @Override
    public synchronized void setObject(Object o, int row, int column) throws MatrixException {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public synchronized void setObject(Object o, long row, long column) throws MatrixException {
        Coordinates c = new Coordinates(row / this.tileSize[0], column / this.tileSize[1]);
        ObjectMatrix2D m = this.getMap().get(c);
        if (m == null) {
            m = new DefaultDenseObjectMatrix2D(this.tileSize[0], this.tileSize[1]);
            this.getMap().put(c, m);
        }
        m.setObject(o, row % this.tileSize[0], column % this.tileSize[1]);
    }

    @Override
    public final long[] getSize() {
        return this.size;
    }

    public final long[] getTileSize() {
        return this.tileSize;
    }
}

