/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class Swap
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -6182660661622835051L;
    private long pos1 = 0L;
    private long pos2 = 0L;

    public Swap(int dimension, long pos1, long pos2, Matrix m) {
        super(dimension, m);
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        if (this.pos1 == this.pos2) {
            return this.getSource().getAsObject(coordinates);
        }
        if (coordinates[this.getDimension()] == this.pos1) {
            coordinates = Coordinates.copyOf(coordinates);
            coordinates[this.getDimension()] = this.pos2;
            return this.getSource().getAsObject(coordinates);
        }
        if (coordinates[this.getDimension()] == this.pos2) {
            coordinates = Coordinates.copyOf(coordinates);
            coordinates[this.getDimension()] = this.pos1;
            return this.getSource().getAsObject(coordinates);
        }
        return this.getSource().getAsObject(coordinates);
    }

    public final Matrix calcOrig() throws MatrixException {
        Matrix m = this.getSource();
        if (m.getDimensionCount() > 2) {
            throw new MatrixException("ORIG works only for 2d matrices, use LINK or COPY instead");
        }
        if (this.getDimension() == 0) {
            long length = m.getColumnCount();
            long i = 0L;
            while (i < length) {
                Object temp = m.getAsObject(this.pos1, i);
                m.setAsObject(m.getAsObject(this.pos2, i), this.pos1, i);
                m.setAsObject(temp, this.pos2, i++);
            }
        } else if (this.getDimension() == 1) {
            long length = m.getRowCount();
            long i = 0L;
            while (i < length) {
                Object temp = m.getAsObject(i, this.pos1);
                m.setAsObject(m.getAsObject(i, this.pos2), i, this.pos1);
                m.setAsObject(temp, i++, this.pos2);
            }
        } else {
            throw new MatrixException("this only works for rows or columns");
        }
        return this.getSource();
    }
}

