/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.intmatrix.calculation.AbstractIntCalculation;

public class Magic
extends AbstractIntCalculation {
    private static final long serialVersionUID = -2372321035531662110L;
    private final Matrix magic;

    public Magic(Matrix matrix, int size) {
        super(matrix);
        this.magic = Magic.magic(size);
    }

    public int getInt(long ... coordinates) throws MatrixException {
        return this.magic.getAsInt(coordinates);
    }

    public static Matrix magic(int n) {
        int[][] M = new int[n][n];
        if (n % 2 == 1) {
            int a = (n + 1) / 2;
            int b = n + 1;
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    M[i][j] = n * ((i + j + a) % n) + (i + 2 * j + b) % n + 1;
                    ++i;
                }
                ++j;
            }
        } else if (n % 4 == 0) {
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    M[i][j] = (i + 1) / 2 % 2 == (j + 1) / 2 % 2 ? n * n - n * i - j : n * i + j + 1;
                    ++i;
                }
                ++j;
            }
        } else {
            int p = n / 2;
            int k = (n - 2) / 4;
            Matrix A = Magic.magic(p);
            int j = 0;
            while (j < p) {
                int i = 0;
                while (i < p) {
                    int aij;
                    M[i][j] = aij = A.getAsInt(i, j);
                    M[i][j + p] = aij + 2 * p * p;
                    M[i + p][j] = aij + 3 * p * p;
                    M[i + p][j + p] = aij + p * p;
                    ++i;
                }
                ++j;
            }
            int i = 0;
            while (i < p) {
                int t;
                int j2 = 0;
                while (j2 < k) {
                    t = M[i][j2];
                    M[i][j2] = M[i + p][j2];
                    M[i + p][j2] = t;
                    ++j2;
                }
                j2 = n - k + 1;
                while (j2 < n) {
                    t = M[i][j2];
                    M[i][j2] = M[i + p][j2];
                    M[i + p][j2] = t;
                    ++j2;
                }
                ++i;
            }
            int t = M[k][0];
            M[k][0] = M[k + p][0];
            M[k + p][0] = t;
            t = M[k][k];
            M[k][k] = M[k + p][k];
            M[k + p][k] = t;
        }
        return MatrixFactory.linkToArray(M);
    }
}

